<?php
/**
 * @package WP Links Page Pro (Personal Version)
 * @version 4.7 */
/*
Plugin Name: WP Links Page Pro
Plugin URI:  http://www.wplinkspage.com/
Description: This plugin provides an easy way to add links to your site.
Version: 4.7-PRS
Author: Robert Macchi
*/

include_once(ABSPATH.'wp-admin/includes/plugin.php');

function wplp_is_requirements_met() {

    // Check if WP Links Page Pro is active
    if ( is_plugin_active('wp-links-page/wp-links-page-free.php') && get_option('wplp_pro_passes_req') != 'true') {
        return false;
    }

    return true;
}

function wplp_disable_plugin() {

    if ( current_user_can('activate_plugins') && is_plugin_active( plugin_basename( __FILE__ ) ) ) {
        deactivate_plugins( plugin_basename( __FILE__ ) );
        if ( isset( $_GET['activate'] ) ) {
            unset( $_GET['activate'] );
        }
    }
}

function wplp_show_notice() {
  	echo '<div class="notice notice-error"><p><strong>WP Links Page Pro</strong> can\'t be activated while WP Links Page is active. Please deactivate the free version to use WP Links Page Pro.</p></div>';

}

if ( !wplp_is_requirements_met() ) {
	 add_action( 'admin_init', 'wplp_disable_plugin' );
	 add_action( 'admin_notices', 'wplp_show_notice' );
} else {

$upload_dir = wp_upload_dir();
$wplp_upload = $upload_dir['basedir'].'/wp-links-page/';
if( ! file_exists( $wplp_upload ) )
    wp_mkdir_p( $wplp_upload );

if (!defined('WPLP_UPLOAD_DIR')) {
    define('WPLP_UPLOAD_DIR', $wplp_upload);
}

if (!defined('WPLP_UPLOAD_URL')) {
    define('WPLP_UPLOAD_URL', $upload_dir['baseurl'].'/'.'wp-links-page/');
}

/** Require dependencies */
require_once( ABSPATH . 'wp-admin/includes/image.php' );
require_once( ABSPATH . 'wp-admin/includes/file.php' );
require_once( ABSPATH . 'wp-admin/includes/media.php' );
require_once( ABSPATH . 'wp-includes/media-template.php' );

add_filter( 'cron_schedules', 'wp_links_page_add_intervals');

	add_option( 'wplp_screenshot_size', 'large', '', 'yes' );
	add_option( 'wplp_screenshot_refresh', 'weekly', '', 'yes' );
	add_option( 'wplp_role', 'administrator', '', 'yes' );
	add_option( 'wplp_default_favicon', 'false', '', 'yes' );
	add_option( 'wplp_apikey', '', '', 'yes' );

	add_action( 'wpmu_new_blog', 'wplp_new_blog', 10, 6);
	add_action( 'wp_links_page_event', 'wp_links_page_event_hook');

	register_activation_hook(__FILE__, 'wp_links_page_setup_schedule');
	register_deactivation_hook( __FILE__, 'wp_links_page_deactivation');



/** Admin Init **/
if ( is_admin() ) {
	add_action( 'admin_init', 'wp_links_page_settings');
	add_action( 'add_meta_boxes_wplp_link', 'wplp_links_metaboxes' );
	add_action( 'admin_menu', 'wplp_menu');
	add_action( 'admin_enqueue_scripts', 'wplp_admin_enqueue_scripts' );
}



	function wp_links_page_setup_schedule() {
		$screenshot_refresh = esc_attr( get_option('wplp_screenshot_refresh') );
		wp_clear_scheduled_hook( 'wp_links_page_event' );
		wp_clear_scheduled_hook( 'wp_links_page_free_event' );
		wp_schedule_event( time(), $screenshot_refresh, 'wp_links_page_event');
	}

	function wplp_enqueue_shortcode_scripts($posts) {
		wp_register_script(  'wplp-display-js', plugins_url( 'wp-links-page-pro/js/wp-links-display.js', 'wp-links-page-pro' ), array( 'jquery' ), false, true);
		wp_localize_script( 'wplp-display-js', 'ajax_object', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
		wp_register_style( 'wplp-display-style',  plugins_url( 'wp-links-page-pro/css/wp-links-display.css', 'wp-links-page-pro' ), array(), false, 'all' );
		wp_register_script(  'wplp-jscroll-js', plugins_url( 'wp-links-page-pro/js/jquery.jscroll.js', 'wp-links-page-pro' ), array( 'jquery' ), false, true);
		wp_register_script(  'wplp-slick-js', plugins_url( 'wp-links-page-pro/js/slick.js', 'wp-links-page-pro' ), array( 'jquery' ), false, true);
		wp_register_style( 'wplp-slick-style',  plugins_url( 'wp-links-page-pro/css/slick.css', 'wp-links-page-pro' ), array(), false, 'all' );
	}

	add_action( 'wp_enqueue_scripts', 'wplp_enqueue_shortcode_scripts' );

	function wplp_admin_enqueue_scripts( $hook ) {
		global $typenow;
		if (($hook == 'post-new.php' || $hook == 'edit.php' || $hook == 'post.php')  && $typenow == 'wplp_link') {
		wp_enqueue_script('jquery-ui-progressbar');
		wp_enqueue_script( 'wplp-js', plugins_url( 'wp-links-page-pro/js/wp-links-page.js', 'wp-links-page-pro' ), array( 'jquery', 'jquery-ui-progressbar' ), null, true );
		wp_enqueue_script( 'wplp-qe-js', plugins_url( 'wp-links-page-pro/js/wp-links-page-quick-edit.js', 'wp-links-page-pro' ), array( 'jquery', 'inline-edit-post' ), '', true );
		wp_localize_script( 'wplp-js', 'ajax_object', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
		$translation_array = array( 'pluginUrl' => plugins_url( 'wp-links-page-pro' ) );
		//after wp_enqueue_script
		wp_localize_script( 'wplp-js', 'wplp', $translation_array );
		wp_enqueue_style('wplp-admin-ui-css', plugins_url( 'wp-links-page-pro/css/jquery-ui.css', 'wp-links-page-pro' ),false, '', false);
		wp_enqueue_style( 'wplp-style',  plugins_url( 'wp-links-page-pro/css/wp-links-page.css', 'wp-links-page-pro' ), null, null, false );
		} else if ($hook == 'wplp_link_page_wplp_subpage-menu') {
			wp_enqueue_script('jquery-ui-progressbar');
			wp_enqueue_script( 'wplp-js', plugins_url( 'wp-links-page-pro/js/wp-links-page.js', 'wp-links-page-pro' ), array( 'jquery', 'jquery-ui-progressbar' ), null, true );
			wp_localize_script( 'wplp-js', 'ajax_object', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
			wp_enqueue_media();
			wp_enqueue_style('wplp-admin-ui-css', plugins_url( 'wp-links-page-pro/css/jquery-ui.css', 'wp-links-page-pro' ),false, '', false);
			wp_enqueue_style( 'wplp-style',  plugins_url( 'wp-links-page-pro/css/wp-links-page.css', 'wp-links-page-pro' ), null, null, false );
		} else if ($hook == 'wplp_link_page_wplp_subpage3-menu') {
			wp_enqueue_script( 'wplp-shortcode-js', plugins_url( 'wp-links-page-pro/js/wp-links-shortcode.js', 'wp-links-page-pro' ), array( 'jquery', 'jquery-ui-tabs' ), null, true );
			wp_enqueue_style( 'wplp-style',  plugins_url( 'wp-links-page-pro/css/wp-links-page.css', 'wp-links-page-pro' ), null, null, false );
			wp_enqueue_style( 'ti-style',  plugins_url( 'wp-links-page-pro/css/themify-icons.css', 'wp-links-page-pro' ), null, null, false );
		} else if ($hook == 'wplp_link_page_wplp_subpage2-menu') {
			wp_enqueue_style( 'wplp-style',  plugins_url( 'wp-links-page-pro/css/wp-links-page.css', 'wp-links-page-pro' ), null, null, false );
		}

	}

function wp_links_page_add_intervals($schedules) {
		$schedules['twodays'] = array(
			'interval' => 172800,
			'display' => __('Every Other Day')
		);
		$schedules['threedays'] = array(
			'interval' => 259200,
			'display' => __('Every Three Days')
		);
		$schedules['weekly'] = array(
			'interval' => 604800,
			'display' => __('Weekly')
		);
		$schedules['biweekly'] = array(
			'interval' => 1209600,
			'display' => __('Every Two Weeks')
		);
		$schedules['monthly'] = array(
			'interval' => 2635200,
			'display' => __('Monthly')
		);
		return $schedules;
	}

	function wp_links_page_deactivation() {
		wp_clear_scheduled_hook( 'wp_links_page_event' );
	}

	function wp_links_page_event_hook() {
		global $wpdb;
		$custom_post_type = 'wplp_link';
		$results = $wpdb->get_results( $wpdb->prepare( "SELECT ID FROM {$wpdb->posts} WHERE post_type = %s and post_status = 'publish'", $custom_post_type ), ARRAY_A );
		$total = '';

		foreach ($results as $index => $post) {
			$arg = array($post['ID'],false);
			wp_schedule_single_event( time(), 'wp_ajax_wplp_ajax_update_screenshots', $arg );
		}
	}


	function wplp_ajax_update_screenshots($id = '', $override = false) {
		if (isset($_REQUEST['id'])) {
			$id = $_REQUEST['id'];
			$id = sanitize_text_field($id);
		} elseif (empty($id)) {
		 die(json_encode(array('message' => 'ERROR', 'code' => 1336)));
		}

		$post = get_post($id);
		$mk = wplp_filter_metadata( get_post_meta( $id ) );

		$ss_size = get_option('wplp_screenshot_size');

		if (!empty($mk['wplp_screenshot_url'])) {
			$url = $mk['wplp_screenshot_url'];
		} else { $url = $post->post_title; }

		if (!empty($mk['wplp_display'])) {
			$display = $mk['wplp_display'];
		} else { $display = $post->post_title; }

		if (isset($url)) {
			if (!(substr($url, 0, 4) == 'http')) {
				$url = 'https://' . $url;
			}
		}else {die();}


		if ($mk['wplp_no_update'] != 'no' && $mk['wplp_media_image'] != 'true') {

			if ($ss_size == 'large') {

          $wplp_featured_image = "http://s.wordpress.com/mshots/v1/".$url."?w=1280";

					// Add Featured Image to Post
					$image_url        = $wplp_featured_image; // Define the image URL here
					$image_name       = preg_replace("/[^a-zA-Z0-9]+/", "", $display);
					wplp_large_screenshot($image_url, $image_name, $id);

				} elseif ($ss_size == 'small') {

					$image_name       = preg_replace("/[^a-zA-Z0-9]+/", "", $display);
					wplp_small_screenshot_url($image_name, $url, $id);
				}
			}
	}

	add_action( 'wp_ajax_wplp_ajax_update_screenshots', 'wplp_ajax_update_screenshots');


function wplp_menu() {

		$role = esc_attr( get_option('wplp_role') );
		if ($role == 'administrator') {
			$capability = 'manage_options';
		} elseif ($role == 'editor') {
			$capability = 'delete_others_pages';
		} elseif ($role == 'author') {
			$capability = 'publish_posts';
		} elseif ($role == 'contributor') {
			$capability = 'edit_posts';
		} elseif ($role == 'subscriber') {
			$capability = 'read';
		} else $capability = 'manage_options';


		$wplp_subpage3 = add_submenu_page(
			'edit.php?post_type=wplp_link',
			'WP Links Page Pro | Shortcode',
			'Shortcode',
			$capability,
			'wplp_subpage3-menu',
			'wplp_shortcode_page');
		$wplp_subpage = add_submenu_page(
			'edit.php?post_type=wplp_link',
			'WP Links Page Pro | Settings',
			'Settings',
			$capability,
			'wplp_subpage-menu',
			'wplp_subpage_options');
		$wplp_subpage2 = add_submenu_page(
			'edit.php?post_type=wplp_link',
			'WP Links Page Pro | Help',
			'Help',
			$capability,
			'wplp_subpage2-menu',
			'wplp_help_page');

	}









function my_custom_post_wplp_link() {

	$role = esc_attr( get_option('wplp_role') );
	if ($role == 'administrator') {
		$capability = 'manage_options';
	} elseif ($role == 'editor') {
		$capability = 'delete_others_pages';
	} elseif ($role == 'author') {
		$capability = 'publish_posts';
	} elseif ($role == 'contributor') {
		$capability = 'edit_posts';
	} elseif ($role == 'subscriber') {
		$capability = 'read';
	} else $capability = 'manage_options';

  $labels = array(
    'name'               => _x( 'Links', 'post type general name' ),
    'singular_name'      => _x( 'Link', 'post type singular name' ),
    'add_new'            => _x( 'Add New', 'Link' ),
    'add_new_item'       => __( 'Add New Link' ),
    'edit_item'          => __( 'Edit Link' ),
    'new_item'           => __( 'New Link' ),
    'all_items'          => __( 'All Links' ),
    'view_item'          => __( 'View Link' ),
    'search_items'       => __( 'Search Links' ),
    'not_found'          => __( 'No Links found' ),
    'not_found_in_trash' => __( 'No Links found in the Trash' ),
    'parent_item_colon'  => '',
    'menu_name'          => 'WP Links Pro'
  );
  $args = array(
    'labels'        => $labels,
    'description'   => 'Holds our products and product specific data',
    'public'        => false,
    'menu_position' => 5,
    'supports'      => array( 'title', 'editor', 'thumbnail' ),
    'has_archive'   => true,
	'show_in_menu'	=> true,
	'show_ui'		=> true,
	'menu_icon'     => 'dashicons-admin-links',
	'capabilities' => array(
				'edit_post'          => $capability,
				'read_post'          => $capability,
				'delete_post'        => $capability,
				'edit_posts'         => $capability,
				'edit_others_posts'  => $capability,
				'delete_posts'       => $capability,
				'publish_posts'      => $capability,
				'read_private_posts' => $capability
	)
   /* 'taxonomies' => array( 'category', 'post_tag' )*/


  );
  register_post_type( 'wplp_link', $args );
}
add_action( 'init', 'my_custom_post_wplp_link' );



function my_taxonomies_wplp_link() {
	$role = esc_attr( get_option('wplp_role') );
	if ($role == 'administrator') {
		$capability = 'manage_options';
	} elseif ($role == 'editor') {
		$capability = 'delete_others_pages';
	} elseif ($role == 'author') {
		$capability = 'publish_posts';
	} elseif ($role == 'contributor') {
		$capability = 'edit_posts';
	} elseif ($role == 'subscriber') {
		$capability = 'read';
	} else $capability = 'manage_options';


  $labels = array(
    'name'              => _x( 'Categories', 'taxonomy general name' ),
    'singular_name'     => _x( 'Category', 'taxonomy singular name' ),
    'search_items'      => __( 'Search Link Categories' ),
    'all_items'         => __( 'All Link Categories' ),
    'parent_item'       => __( 'Parent Link Category' ),
    'parent_item_colon' => __( 'Parent Link Category:' ),
    'edit_item'         => __( 'Edit Link Category' ),
    'update_item'       => __( 'Update Link Category' ),
    'add_new_item'      => __( 'Add New Link Category' ),
    'new_item_name'     => __( 'New Link Category' ),
    'menu_name'         => __( 'Categories' ),
  );
  $args = array(
    'labels' => $labels,
    'hierarchical' => true,
	'show_admin_column' => true,
	'capabilities' => array(
				'manage_terms'        => $capability,
				'edit_terms'          => $capability,
				'delete_terms'        => $capability,
				'assign_terms'        => $capability,
	)

  );
  register_taxonomy( 'wplp_link_category', 'wplp_link', $args );
}
add_action( 'init', 'my_taxonomies_wplp_link', 0 );


add_action( 'init', 'create_tag_taxonomies', 0 );

//create two taxonomies, genres and tags for the post type "tag"
function create_tag_taxonomies()
{
	$role = esc_attr( get_option('wplp_role') );
	if ($role == 'administrator') {
		$capability = 'manage_options';
	} elseif ($role == 'editor') {
		$capability = 'delete_others_pages';
	} elseif ($role == 'author') {
		$capability = 'publish_posts';
	} elseif ($role == 'contributor') {
		$capability = 'edit_posts';
	} elseif ($role == 'subscriber') {
		$capability = 'read';
	} else $capability = 'manage_options';
  // Add new taxonomy, NOT hierarchical (like tags)
  $labels = array(
    'name' => _x( 'Tags', 'taxonomy general name' ),
    'singular_name' => _x( 'Tag', 'taxonomy singular name' ),
    'search_items' =>  __( 'Search Tags' ),
    'popular_items' => __( 'Popular Tags' ),
    'all_items' => __( 'All Tags' ),
    'parent_item' => null,
    'parent_item_colon' => null,
    'edit_item' => __( 'Edit Tag' ),
    'update_item' => __( 'Update Tag' ),
    'add_new_item' => __( 'Add New Tag' ),
    'new_item_name' => __( 'New Tag Name' ),
    'separate_items_with_commas' => __( 'Separate tags with commas' ),
    'add_or_remove_items' => __( 'Add or remove tags' ),
    'choose_from_most_used' => __( 'Choose from the most used tags' ),
    'menu_name' => __( 'Tags' ),
  );

  register_taxonomy('wplp_tag','wplp_link',array(
    'hierarchical' => false,
    'labels' => $labels,
    'show_ui' => true,
	'show_admin_column' => true,
    'update_count_callback' => '_update_post_term_count',
    'query_var' => true,
    'rewrite' => array( 'slug' => 'wplp-tag' ),
	'capabilities' => array(
				'manage_terms'        => $capability,
				'edit_terms'          => $capability,
				'delete_terms'        => $capability,
				'assign_terms'        => $capability,
	)
  ));
}

/**
 * Custom Cat Filter
  */



add_action('restrict_manage_posts', 'tsm_filter_post_type_by_taxonomy');
function tsm_filter_post_type_by_taxonomy() {
	global $typenow;
	$post_type = 'wplp_link'; // change to your post type
	$taxonomy  = 'wplp_link_category'; // change to your taxonomy
	if ($typenow == $post_type) {
		$selected      = isset($_GET[$taxonomy]) ? $_GET[$taxonomy] : '';
		$info_taxonomy = get_taxonomy($taxonomy);
		wp_dropdown_categories(array(
			'show_option_all' => __("Show All {$info_taxonomy->label}"),
			'taxonomy'        => $taxonomy,
			'name'            => $taxonomy,
			'orderby'         => 'name',
			'selected'        => $selected,
			'show_count'      => true,
			'hide_empty'      => true,
			'hide_if_empty'      => true,
			'hierarchical'       => 1,


		));
	};
}

/**
 * Filter posts by taxonomy in admin
 * @author  Mike Hemberger
 * @link http://thestizmedia.com/custom-post-type-filter-admin-custom-taxonomy/
 */
add_filter('parse_query', 'tsm_convert_id_to_term_in_query');
function tsm_convert_id_to_term_in_query($query) {
	global $pagenow;
	$post_type = 'wplp_link'; // change to your post type
	$taxonomy  = 'wplp_link_category'; // change to your taxonomy
	$q_vars    = &$query->query_vars;
	if ( $pagenow == 'edit.php' && isset($q_vars['post_type']) && $q_vars['post_type'] == $post_type && isset($q_vars[$taxonomy]) && is_numeric($q_vars[$taxonomy]) && $q_vars[$taxonomy] != 0 ) {
		$term = get_term_by('id', $q_vars[$taxonomy], $taxonomy);
		$q_vars[$taxonomy] = $term->slug;
	}
}


/**
 * Query Filter for Custom Post Types
 */
 function wplp_query_filter($query) {

	global $pagenow;
  if ( is_admin() && $query->query['post_type'] == 'wplp_link' && $pagenow == 'edit.php') {
	$query->set( 'orderby', 'ID' );
    $query->set( 'order', 'DESC' );
  }
}


add_action('pre_get_posts','wplp_query_filter');

/**
 * Change edit.php page
*/





add_action( 'load-edit.php', function() {
  add_filter( 'views_edit-wplp_link', 'wplp_link_edit' );
});

function wplp_link_edit($views) {
	global $wpdb;
	$custom_post_type = 'wplp_link';
    $results = $wpdb->get_results( $wpdb->prepare( "SELECT ID FROM {$wpdb->posts} WHERE post_type = %s and post_status = 'publish'", $custom_post_type ), ARRAY_A );
	$total = '';
	$update = '';

    foreach( $results as $index => $post ) {
		if ($total == '') {
			$total = $post['ID'];
		} else {
        	$total .= ','.$post['ID'];
		}
    }


 echo '

  <button id="update-screenshots" class="button button-primary button-large" style="float:left; margin-right: 20px;" data-total="'.$total.'">Update Screenshots</button>
	<div id="progressbar">
              <div class="progress-label"></div>
        </div><div class="clearfix" style="clear:both"></div>

 ';
 return $views;
}

add_action( 'admin_head-edit.php', 'wplp_quick_edit_remove' );

function wplp_quick_edit_remove()
{
    /**
       /wp-admin/edit.php?post_type=post
       /wp-admin/edit.php?post_type=page
       /wp-admin/edit.php?post_type=cpt  == gallery in this example
     */

    global $current_screen;
    if( 'edit-wplp_link' != $current_screen->id )
        return;
    ?>
    <script type="text/javascript">
        jQuery(document).ready( function($) {
			$('span.title:contains("Title")').each(function (i) {
                $(this).html('Link Url');
				$(this).parent().parent().append('<label><span class="title">Link Display</span><span class="input-text-wrap"><input type="text" name="wplp_display" value="" /></span></label><label><span class="title">Description</span><textarea name="wplp_description"></textarea></label><br class="clear">');
            });
			$('span:contains("Slug")').each(function (i) {
                $(this).parent().remove();
            });
            $('span:contains("Password")').each(function (i) {
                $(this).parent().parent().remove();
            });
            $('span:contains("Date")').each(function (i) {
                $(this).parent().remove();
            });
            $('.inline-edit-date').each(function (i) {
                $(this).remove();
            });
			$('#wplp-custom.inline-edit-col-left').each(function (i) {
				$(this).css('font-weight:bold;');
			});
        });
    </script>
    <?php
}
/**
 * Edit Custom Post Type List
 */

 add_filter( 'manage_wplp_link_posts_columns', 'set_custom_edit_wplp_link_columns' );
 add_action( 'manage_wplp_link_posts_custom_column' , 'wplp_custom_columns', 10, 2 );

function set_custom_edit_wplp_link_columns($columns) {
    unset( $columns['author'] );
    unset( $columns['date'] );
    $columns['screenshot'] = 'Screenshot';
    $columns['description'] = 'Description';
	$columns['title'] = 'Link Display';
    $columns['id'] = 'ID';

	$a = $columns;
	$b = array('cb', 'screenshot', 'title', 'description', 'taxonomy-wplp_link_category', 'taxonomy-wplp_tag', 'id'); // rule indicating new key order
	$c = array();
	foreach($b as $index) {
		$c[$index] = $a[$index];
	}
	$columns = $c;

    return $columns;
}

function wplp_custom_columns( $column, $post_id ) {
	switch ( $column ) {
		case 'id':
			echo $post_id;
			break;
		case 'screenshot':
			$display = get_post_meta( $post_id, 'wplp_display', true );
			$image = get_the_post_thumbnail( $post_id, 'thumbnail' );
			echo $image.'<p id="wplp_display_'.$post_id.'" class="hidden">'.$display.'</p>';
			break;


	case 'description':
			$content_post = get_post($post_id);
			$content = $content_post->post_content;
			$content = apply_filters('the_content', $content);
			$content = str_replace(']]>', ']]&gt;', $content);
			echo '<div id="wplp_description_'.$post_id.'">'.$content.'</div>';
			break;

	}
}


function wplp_link_display_title( $title, $id = null ) {
	if (is_admin()) {
		if (get_post_type($id) == 'wplp_link') {
			$display = get_post_meta( $id, 'wplp_display', true );
			if ($display == '') {
				$display = $title;
			}
			return $display;
		} else { return $title; }
	} else { return $title; }
}
add_filter( 'the_title', 'wplp_link_display_title', 10, 2 );


/**
 *   Adds a metabox
 */
function wplp_links_metaboxes() {

	add_meta_box(
		'wplp_screenshot',
		'Screenshot',
		'wplp_post_thumbnail_meta_box',
		'wplp_link',
		'advanced',
		'default' );

	add_meta_box(
		'wplp_metadata',
		'Metadata',
		'wplp_metadata_box',
		'wplp_link',
		'normal',
		'default' );

	add_meta_box(
		'wplp_display',
		'Link Display',
		'wplp_display_func',
		'wplp_link',
		'advanced',
		'default'
	);

}

/* Move Screenshot Metabox to before title */

add_action('edit_form_after_title', function() {
    global $post, $wp_meta_boxes, $typenow;
	if ($typenow == 'wplp_link') {
		do_meta_boxes(get_current_screen(), 'advanced', $post);
		unset($wp_meta_boxes[get_post_type($post)]['advanced']);
	}
});

function wplp_display_func() {

	global $post;
	// Nonce field to validate form request came from current site
	wp_nonce_field( basename( __FILE__ ), 'wplp_fields' );

	// Get the display data if it's already been entered
	$display = get_post_meta( $post->ID, 'wplp_display', true );
	if ($display == "Auto Draft") { $display = ''; }

    echo '
    <input id="wplp_display" size="30" name="wplp_display" maxlength="255" type="text" value="'.$display.'" placeholder="Link Title"><br/><p class="description">This field defaults to the link domain. You are limited to 255 characters here, but you can also provide more information about the link in the editor below.</p>';

}

function wplp_post_thumbnail_meta_box( $post ) {
	$mk = wplp_filter_metadata( get_post_meta( $post->ID ) );
	$thumb_id = get_post_thumbnail_id( $post->ID );
	$thumb = wp_get_attachment_url($thumb_id);
	if ($thumb != '' ) {
		$display = '';
	} else $display = 'display:none;';

	$loading = plugin_dir_url( __FILE__ ) . 'images/loading.gif';
	$screenshot_size = get_option( 'wplp_screenshot_size');
	if (isset($mk['wplp_media_image'])) { $media = $mk['wplp_media_image'];} else {$media = '';}
	if (isset($mk['wplp_screenshot_url'])) { $screenshot_url = $mk['wplp_screenshot_url'];} else {$screenshot_url = '';}
	if (isset($mk['wplp_no_update'])) { $no_update = $mk['wplp_no_update'];} else {$no_update = '';}
	if (empty($media)) $media = 'false';

		echo '
		<div id="titlediv">
<div id="titlewrap">
	<input type="text" name="post_title" size="30" value="'.$post->post_title.'" placeholder="Link Url" class="ss" id="title" spellcheck="true" autocomplete="off">
</div>
	</div>
	<p class="description">Enter the Link Url in this field. The screenshot will generate automatically as soon as you are finished. If the screenshot is not generating properly try using the full url including the "http://" or "https://".</p>
		<img class="wplp_featured" src="'.$thumb.'" style="'.$display.' width:300px; margin: 10px 0;" />
		<div class="wplp_loading" style="width: 300px; display:none;text-align: center; border: 1px solid #DDD; margin: 10px 0;">
		<img class="wplp_loading" src="'.$loading.'" style="display:none; width: 100px;" />
		<p class="wplp_loading" style="display: none;">Generating Screenshot...</p>
		</div>
		<br>
		<label for"wplp_screenshot_url"><b>Screenshot URL: &nbsp;&nbsp;<b></label><input id="wplp_screenshot_url" type="text" name="wplp_screenshot_url" value="'.$screenshot_url.'" style="width: 80%;"/>
		<p class="description">This field is useful for affiliate links. Your affiliate link can go in the "Link URL" field above, and the direct URL can go in the "Screenshot URL" field to retrieve the expected screenshot. Click "Generate New Screenshot" after entering the url below to retrieve the new screenshot.</p>
		<input id="wplp_media_image" type="hidden" name="wplp_media_image" value="'.$media.'" />
		<input id="wplp_featured_image" type="hidden" name="wplp_featured_image" value="'.$thumb_id.'" />
		<input id="wplp_screenshot_size" type="hidden" name="wplp_screenshot_size" value="'.$screenshot_size.'" />
		<br>
		<p class="hide-if-no-js">
		<a class="set-featured-thumbnail setfeatured button" href="#" title="Choose Image">Choose Image</a>
		&nbsp;<input id="apikey" type="hidden" class="apikey" value="'.esc_attr( get_option('wplp_apikey')).'" /><a class="set-featured-screenshot generate button button-primary" href="#" title="Generate New Screenshot">Generate New Screenshot</a><br>
		<br><label for="wplp_no_update"><input id="wplp_no_update" type="checkbox" name="wplp_no_update" value="no"';
		if ($no_update == 'no') {
			echo 'checked="checked"';
		} else echo 'data="not checked"';
		echo ' />Don\'t update this screenshot. Keep the current image.</label>';
}

function wplp_metadata_box($post) {
	$mk = wplp_filter_metadata( get_post_meta( $post->ID ) );
	if (isset($mk['wplp_favicon'])) {$fav_url = wp_get_attachment_url($mk['wplp_favicon']);} else {$fav_url = '';}
	if (isset($mk['wplp_favicon'])) {$favicon = $mk['wplp_favicon'];} else {$favicon = '';}
	if (isset($mk['wplp_media_fav'])) {$fav_media = $mk['wplp_media_fav'];} else {$fav_media = '';}
	if (isset($mk['wplp_meta_title'])) {$mtitle = $mk['wplp_meta_title'];} else {$mtitle = '';}
	if (isset($mk['wplp_meta_desc'])) {$mdesc = $mk['wplp_meta_desc'];} else {$mdesc = '';}

	if (empty($fav_media)) $fav_media = 'false';

	echo '<p class="description">The metadata will be imported automatically after you enter the Link Url above. This data is pulled directly from the webpage and can be used in your WP Links Page Shortcodes.</p>
	<p id="WPLPNotAllowed" class="error">This Url may have other MetaData, but WP Links Page Pro cannot fetch it because the Url is blocking our access to it. You will need to enter it manually to use this link with any MetaData Displays.</p>
	<div class="metatitle">
		<label>Meta Title</label><br>
		<input id="wplp_meta_title" type="text" name="wplp_meta_title" value="'.$mtitle.'" style="width:100%;" />
		<p class="error">No Meta Title detected, please add it manually.</p>
		</div>
		<div class="favicon" >
		<br><label>Favicon</label><br>
		<img class="wplp_favicon" src="'.$fav_url.'" style="" /><br>
		<input id="wplp_media_fav" type="hidden" name="wplp_media_fav" value="'.$fav_media.'" />
		<input id="wplp_favicon" type="hidden" name="wplp_favicon" value="'.$favicon.'" /><a class="set-favicon button" href="#" title="Choose Favicon">Set Favicon</a><br>
		<p class="error">No Favicon detected, using default. You can change it manually by clicking "Choose Favicon" above.</p>
		</div>
	<div class="meta" >
	<br><label>Meta Description</label><br>
		<textarea id="wplp_meta_desc" name="wplp_meta_desc" style="width: 100%;">'.$mdesc.'</textarea><br>
		<p class="error">No Meta Description detected, please add it manually.</p>
		</div>
		<br><br><a id="set-featured-metadata" class="generate button" href="#" title="Fetch New Metadata" >Update Metadata</a>';
}

function file_get_contents_curl($url) {
    $ch = curl_init();

    curl_setopt($ch, CURLOPT_AUTOREFERER, TRUE);
    curl_setopt($ch, CURLOPT_HEADER, 0);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);

    $data = curl_exec($ch);
    curl_close($ch);

    return $data;
}

function wplp_meta_info() {
	if (isset($_REQUEST['url'])) {
			$url = $_REQUEST['url'];
			$url = sanitize_text_field($url);
		} else die(json_encode(array('message' => 'ERROR', 'code' => 1400)));

	$url = trim($url, '/');
	if (isset($url)) {
		if (!(substr($url, 0, 4) == 'http')) {
			$url2 = 'https://' . $url;
			$host = 'https://';
		} elseif ((substr($url, 0, 5) == 'https')) {
			$host = 'https://';
			$url2 = $url;
		} elseif ((substr($url, 0, 4) == 'http')) {
			$host = 'http://';
			$url2 = $url;
		}
	} else die();
	$html = file_get_contents($url2);
	$final_url = $url2;
	if (empty($html)) {
		$url3 = 'http://' . $url;
		$host = 'http://';
		$html = file_get_contents($url3);
		$final_url = $url2;
	}
	if (empty($html)) {
		$html = file_get_contents_curl($url2);
		$final_url = $url2;
	}
	if (empty($html)) {
		$html = file_get_contents_curl($url3);
		$final_url = $url3;
	}
	if (empty($html)) {
		die(json_encode(array('message' => 'ERROR', 'code' => 1444)));
	}

	$title = '';
	$description = '';
	$favicon = '';

	$html = mb_convert_encoding($html, 'UTF-8', mb_detect_encoding($html,'UTF-8, ISO-8859-1', true));
	$doc = new DOMDocument();
	@$doc->loadHTML($html);

	$metas = $doc->getElementsByTagName('meta');
	for ($i = 0; $i < $metas->length; $i++)
	{
		$meta = $metas->item($i);
		if(strcasecmp($meta->getAttribute('name'),"description") == '0') {
			if ($description == '') {
				$description = $meta->getAttribute('content');
			}
		}

	}

	$links = $doc->getElementsByTagName('link');
	for ($i = 0; $i < $links->length; $i++)
	{
		$link = $links->item($i);
		if(strcasecmp($link->getAttribute('rel'),'shortcut icon') == '0' || strcasecmp($link->getAttribute('rel'),'icon') == '0') {
			$favicon = $link->getAttribute('href');
		}
	}

	$title = $doc->getElementsByTagName('title');

	if ($title->length){
		$title = $title->item(0)->nodeValue;
	}


	$favicon = rtrim($favicon, '/');
	if (isset($favicon) && $favicon != '') {
		$parse = parse_url($final_url);
		$domain = $parse['host'];
		if (strlen($favicon)>2 && (substr($favicon, 0, 1) == '/') && !(substr($favicon, 0, 2) == '//')) {
			if (!(substr($url, 0, 4) == 'http') ) {
				$favicon = $host . $url . $favicon;
			} else {
				$favicon = $url  . $favicon;
			}
		} elseif (!(substr($favicon, 0, 4) == 'http') && (substr($favicon, 0, 2) == '//')) {

			$favicon = trim($favicon, '/');
			$favicon = $host . $favicon;
		}
	}

	if (!is_string($title)) {
		$title = '';
	}
	if (!is_string($favicon)) {
		$favicon = '';
	}
	if (!is_string($description)) {
		$description = '';
	}


	if(preg_match("/(denied|forbidden|robot)/i", $title)){
			$title = "WPLPNotAllowed";
	}

	die(json_encode(array('message' => array('title' => $title, 'favicon' => $favicon, 'description' => $description, ))));
	}

	add_action( 'wp_ajax_wplp_meta_info', 'wplp_meta_info');


	function wplp_meta_info_for_import($url) {
	if (empty($url)) {
		return;
	}

	if (isset($url)) {
		if (!(substr($url, 0, 4) == 'http')) {
			$url2 = 'https://' . $url;
			$host = 'https://';
		} elseif ((substr($url, 0, 5) == 'https')) {
			$host = 'https://';
			$url2 = $url;
		} elseif ((substr($url, 0, 4) == 'http')) {
			$host = 'http://';
			$url2 = $url;
		}
	} else die();
	$html = file_get_contents($url2);
	$final_url = $url2;
	if (empty($html)) {
		$url3 = 'http://' . $url;
		$host = 'http://';
		$html = file_get_contents($url3);
		$final_url = $url2;
	}
	if (empty($html)) {
		$html = file_get_contents_curl($url2);
		$final_url = $url2;
	}
	if (empty($html)) {
		$html = file_get_contents_curl($url3);
		$final_url = $url3;
	}
	if (empty($html)) {
		die(json_encode(array('message' => 'ERROR', 'code' => 1444)));
	}

	$title = '';
	$description = '';
	$favicon = '';

	$html = mb_convert_encoding($html, 'UTF-8', mb_detect_encoding($html,'UTF-8, ISO-8859-1', true));
	$doc = new DOMDocument();
	@$doc->loadHTML($html);

	$metas = $doc->getElementsByTagName('meta');
	for ($i = 0; $i < $metas->length; $i++)
	{
		$meta = $metas->item($i);
		if(strcasecmp($meta->getAttribute('name'),"description") == '0') {
			if ($description == '') {
				$description = $meta->getAttribute('content');
			}
		}

	}

	$links = $doc->getElementsByTagName('link');
	for ($i = 0; $i < $links->length; $i++)
	{
		$link = $links->item($i);
		if(strcasecmp($link->getAttribute('rel'),'shortcut icon') == '0' || strcasecmp($link->getAttribute('rel'),'icon') == '0') {
			$favicon = $link->getAttribute('href');
		}
	}

	$title = $doc->getElementsByTagName('title');

	if ($title->length){
		$title = $title->item(0)->nodeValue;
	}


	$favicon = rtrim($favicon, '/');
	if (isset($favicon) && $favicon != '') {
		$parse = parse_url($final_url);
		$domain = $parse['host'];
		if (strlen($favicon)>2 && (substr($favicon, 0, 1) == '/') && !(substr($favicon, 0, 2) == '//')) {
			if (!(substr($url, 0, 4) == 'http') ) {
				$favicon = $host . $url . $favicon;
			} else {
				$favicon = $url  . $favicon;
			}
		} elseif (!(substr($favicon, 0, 4) == 'http') && (substr($favicon, 0, 2) == '//')) {

			$favicon = trim($favicon, '/');
			$favicon = $host . $favicon;
		}
	}


	if (!is_string($title)) {
		$title = '';
	}
	if (!is_string($favicon)) {
		$favicon = '';
	}
	if (!is_string($description)) {
		$description = '';
	}

	if(preg_match("/(denied|forbidden|robot)/i", $title)){
			$title = "WPLPNotAllowed";
	}

	return(json_encode(array('title' => $title, 'favicon' => $favicon, 'description' => $description)));
	}


	function wplp_update_from_previous() {
		if (isset($_REQUEST['id'])) {
			$id = $_REQUEST['id'];
			$id = sanitize_text_field($id);
		} else die(json_encode(array('message' => 'ERROR', 'code' => 'no id')));
		$ss_size = get_option('wplp_screenshot_size');
		global $wpdb;
		$table = $wpdb->prefix.'wp_links_page_table';
		$links = $wpdb->get_results("SELECT * FROM $table WHERE id = $id ORDER BY weight");
			foreach ($links as $link) {

				if (!empty($link->display)) {
					$display = $link->display;
				} else { $display = $link->url; }

				if (!empty($link->category)) {
					$cat = get_term_by( 'name', $link->category, 'wplp_link_category' );
					if ($cat != false) {
						$category = array($cat->term_id);
					} else {
						$cat = wp_insert_term($link->category, 'wplp_link_category', array() );
						$category = array($cat['term_id']);
					}
				}
				$metadata = wplp_meta_info_for_import($link->url);
				$metadata = json_decode($metadata);
				if ($metadata->title == 'WPLPNotAllowed') {$metadata->title = '';}
				if ($link->no_update == 1) {
					$no_update = 'no';
				} else {
					$no_update = 'false';
				}
				$new_link = array(
				  'post_title'    => sanitize_text_field( $link->url ),
				  'post_content'  => wp_kses_post($link->description),
				  'post_status'   => 'publish',
				  'post_type'	  => 'wplp_link',
				  'post_category' => $category,
				  'meta_input' => array(
									'wplp_display' => sanitize_text_field($display),
									'wplp_meta_title' => sanitize_text_field($metadata->title),
									'wplp_meta_desc' => sanitize_text_field($metadata->description),
									'wplp_no_update' => $no_update,
									'wplp_screenshot_url' => $link->ssurl,
									'wplp_media_image' => 'false',
									'wplp_media_fav' => 'false',
								),
				);
				$new = wp_insert_post( $new_link );
				if ($new != 0) {
				wp_set_post_terms( $new, $category, 'wplp_link_category' );
				}

				if (!empty($link->ssurl)) {
					$url = $link->ssurl;
				} else { $url = $link->url; }

				if (isset($url)) {
					if (!(substr($url, 0, 4) == 'http')) {
						$url = 'https://' . $url;
					}
				}else {die();}

				if ( isset( $metadata->favicon ) && $metadata->favicon != '') {

					if ($metadata->favicon != '') {
					if (!is_numeric($metadata->favicon) ) {
						// Add Favicon Image to Post
						$domain = preg_replace("/[^a-zA-Z0-9]+/", "", $url);
						$domain = str_replace('.','',$domain);
						$stripped = strtok($metadata->favicon, "?");
						$image_url        = $metadata->favicon; // Define the image URL here
						$image_name       = preg_replace("/[^a-zA-Z0-9]+/", "", $display).'-favicon';
						wplp_favicon($image_url, $image_name, $new);
					}

					} else {
						$favicon = file_get_contents($url1.'/favicon.ico');
						$fav_url = $url1.'/favicon.ico';
						if (empty($favicon)) {
							if ((substr($url1, 0, 5) == 'https')) {
								$favicon = file_get_contents_curl($fav_url);
							}
						}
						if (empty($favicon)) {
							if (!(substr($url, 0, 4) == 'http')) {
								$favicon = file_get_contents('https://'.$url1.'/favicon.ico');
								$fav_url = 'https://'.$url1.'/favicon.ico';
							}
						}
						if (empty($favicon)) {
							if (!(substr($url, 0, 4) == 'http')) {
								$favicon = file_get_contents('http://'.$url1.'/favicon.ico');
								$fav_url = 'http://'.$url1.'/favicon.ico';
							}
						}
						if (empty($favicon)) {
							if (!(substr($url, 0, 3) == 'www') && !(substr($url, 0, 4) == 'http')) {
								$favicon = file_get_contents('https://www.'.$url1.'/favicon.ico');
								$fav_url = 'https://www.'.$url1.'/favicon.ico';
							}
						}
						if (empty($favicon)) {
							if (!(substr($url, 0, 3) == 'www') && !(substr($url, 0, 4) == 'http')) {
								$favicon = file_get_contents('http://www.'.$url1.'/favicon.ico');
								$fav_url = 'http://www.'.$url1.'/favicon.ico';
							}
						}
							// Add Favicon Image to Post
							$fav_array = getimagesize($fav_url);
							list($width, $height, $type, $attr) = $fav_array;

							if (empty($fav_array) || ($width > 10 && $height > 10)) {
								$domain = preg_replace("/[^a-zA-Z0-9]+/", "", $url1);
								$domain = str_replace('.','',$domain);
								$stripped = strtok($fav_url, "?");
								$image_url        = $fav_url; // Define the image URL here
								$image_name       = preg_replace("/[^a-zA-Z0-9]+/", "", $display).'favicon';
								wplp_favicon($image_url, $image_name, $new);
							}

					}
				}


					if ($ss_size == 'large') {

            $wplp_featured_image = "http://s.wordpress.com/mshots/v1/".$url."?w=1280";


							// Add Featured Image to Post
							$image_url        = $wplp_featured_image; // Define the image URL here
							$image_name       = preg_replace("/[^a-zA-Z0-9]+/", "", $display);
							wplp_large_screenshot($image_url, $image_name, $new);

						} elseif ($ss_size == 'small') {

								$image_name       = preg_replace("/[^a-zA-Z0-9]+/", "", $display);
								wplp_small_screenshot_url($image_name, $url, $new);
						}
					}
	}

	add_action( 'wp_ajax_wplp_update_from_previous', 'wplp_update_from_previous');

	function wplp_import_list() {
		if (isset($_REQUEST['url'])) {
			$url = $_REQUEST['url'];
			$url = sanitize_text_field($url);
		} else die(json_encode(array('message' => 'ERROR', 'code' => 'no id')));
		if (isset($_REQUEST['cat'])) {
			$cat = $_REQUEST['cat'];
			$cat = sanitize_text_field($cat);
		} else $cat = '';

		$url1 = $url;

		if (!(substr($url, 0, 4) == 'http')) {
			$url = 'https://' . $url;
		}

		$ss_size = get_option('wplp_screenshot_size');


		if (!empty($cat)) {
			$cat_name = $cat;
			$cat = get_term_by( 'name', $cat, 'wplp_link_category' );
			if ($cat != false) {
				$category = array($cat->term_id);
			} else {
				$cat = wp_insert_term($cat_name, 'wplp_link_category', array() );
				$category = array($cat['term_id']);
			}
		}

		$metadata = wplp_meta_info_for_import($url);
		$metadata = json_decode($metadata);
		if ($metadata->title == 'WPLPNotAllowed') {$metadata->title = '';}

		$no_update = 'false';
		$display = $url;

		$new_link = array(
		  'post_title'    => sanitize_text_field( $url ),
		  'post_status'   => 'publish',
		  'post_type'	  => 'wplp_link',
		  'meta_input' => array(
							'wplp_display' => sanitize_text_field($display),
							'wplp_meta_title' => sanitize_text_field($metadata->title),
							'wplp_meta_desc' => sanitize_text_field($metadata->description),
							'wplp_no_update' => $no_update,
							'wplp_screenshot_url' => '',
							'wplp_media_image' => 'false',
							'wplp_media_fav' => 'false',
						),
		);

		$new = wp_insert_post( $new_link );
		if ($new != 0) {
		wp_set_post_terms( $new, $category, 'wplp_link_category' );
		}

		if ($ss_size == 'large') {

      $wplp_featured_image = "http://s.wordpress.com/mshots/v1/".$url."?w=1280";


				// Add Featured Image to Post
				$image_url        = $wplp_featured_image; // Define the image URL here
				$image_name       = preg_replace("/[^a-zA-Z0-9]+/", "", $display);
				wplp_large_screenshot($image_url, $image_name, $new);

			} elseif ($ss_size == 'small') {
					// Add Featured Image to Post
					$image_name       = preg_replace("/[^a-zA-Z0-9]+/", "", $display);
					wplp_small_screenshot_url($image_name, $url1, $new);
			}

		if ( isset( $metadata->favicon )) {
			if ($metadata->favicon != '') {
			if (!is_numeric($metadata->favicon) ) {
				// Add Favicon Image to Post
				$domain = preg_replace("/[^a-zA-Z0-9]+/", "", $url);
				$domain = str_replace('.','', $domain);
				$stripped = strtok($metadata->favicon, "?");
				$image_url        = $metadata->favicon; // Define the image URL here
				$image_name       = preg_replace("/[^a-zA-Z0-9]+/", "", $display).'favicon';
				wplp_favicon($image_url, $image_name, $new);
			}

			} else {
				$favicon = file_get_contents($url1.'/favicon.ico');
				$fav_url = $url1.'/favicon.ico';
				if (empty($favicon)) {
					if ((substr($url1, 0, 5) == 'https')) {
						$favicon = file_get_contents_curl($fav_url);
					}
				}
				if (empty($favicon)) {
					if (!(substr($url, 0, 4) == 'http')) {
						$favicon = file_get_contents('https://'.$url1.'/favicon.ico');
						$fav_url = 'https://'.$url1.'/favicon.ico';
					}
				}
				if (empty($favicon)) {
					if (!(substr($url, 0, 4) == 'http')) {
						$favicon = file_get_contents('http://'.$url1.'/favicon.ico');
						$fav_url = 'http://'.$url1.'/favicon.ico';
					}
				}
				if (empty($favicon)) {
					if (!(substr($url, 0, 3) == 'www') && !(substr($url, 0, 4) == 'http')) {
						$favicon = file_get_contents('https://www.'.$url1.'/favicon.ico');
						$fav_url = 'https://www.'.$url1.'/favicon.ico';
					}
				}
				if (empty($favicon)) {
					if (!(substr($url, 0, 3) == 'www') && !(substr($url, 0, 4) == 'http')) {
						$favicon = file_get_contents('http://www.'.$url1.'/favicon.ico');
						$fav_url = 'http://www.'.$url1.'/favicon.ico';
					}
				}
					// Add Favicon Image to Post
					$fav_array = getimagesize($fav_url);
					list($width, $height, $type, $attr) = $fav_array;

					if (empty($fav_array) || ($width > 10 && $height > 10)) {
						$domain = preg_replace("/[^a-zA-Z0-9]+/", "", $url1);
						$domain = str_replace('.','',$domain);
						$stripped = strtok($fav_url, "?");
						$image_url        = $fav_url; // Define the image URL here
						$image_name       = preg_replace("/[^a-zA-Z0-9]+/", "", $display).'favicon';
						wplp_favicon($image_url, $image_name, $new);
					}
			}
		}
	}

	add_action( 'wp_ajax_wplp_import_list', 'wplp_import_list');

/**
 * Save the metabox data
 */

 add_filter( 'wp_insert_post_data' , 'wplp_filter_post_data' , '99', 2 );

function wplp_filter_post_data( $data , $postarr ) {
	if (isset($postarr['action'])) {$action = $postarr['action'];} else {$action = '';}
    // Change post content on quick edit
	if ($postarr['post_type'] == 'wplp_link' && $action == 'inline-save') {
		if (isset($postarr['wplp_description'])) {
			$data['post_content'] = wp_kses_post($postarr['wplp_description']);
			$postarr['post_content'] = wp_kses_post($postarr['wplp_description']);
			$postarr['content'] = wp_kses_post($postarr['wplp_description']);
		}
	}
    return $data;
}

function wplp_display_save( $post_id, $post ) {

    /*
     * In production code, $slug should be set only once in the plugin,
     * preferably as a class property, rather than in each function that needs it.
     */
	$post_type = get_post_type($post_id);
	$post_status = get_post_status($post_id);
	 // If this isn't a 'book' post, don't update it.
    if ( "wplp_link" != $post_type || $post_status == 'auto-draft') return;
	if (isset($_POST['action'])) {
	if ( $_POST['action'] == 'wplp_update_from_previous' || $_POST['action'] == 'wplp_import_list') return;
	}
	$mk = wplp_filter_metadata( get_post_meta( $post_id ) );
	if (isset($mk['wplp_favicon'])) {
	$favicon = wp_get_attachment_url($mk['wplp_favicon']);
	} else $favicon = '';

	$ss_size = get_option('wplp_screenshot_size');

    // - Update the post's metadata.
	if ( isset( $_POST['wplp_display'] ) ) {
		update_post_meta( $post_id, 'wplp_display', sanitize_text_field( $_POST['wplp_display'] ) );
	} elseif (!isset($mk['wplp_display'])) {
		update_post_meta( $post_id, 'wplp_display', sanitize_text_field( $_POST['post_title'] ) );
		$_POST['wplp_display'] = $_POST->post_title;
	}


	if ( isset( $_POST['wplp_meta_title'] ) ) {
		update_post_meta( $post_id, 'wplp_meta_title', sanitize_text_field( $_POST['wplp_meta_title'] ) );
	}

	if ( isset( $_POST['wplp_screenshot_url'] ) ) {
		update_post_meta( $post_id, 'wplp_screenshot_url', sanitize_text_field( $_POST['wplp_screenshot_url'] ) );
	}

	if ( isset( $_POST['wplp_favicon'] )) {
		if ($_POST['wplp_favicon'] != '') {
			if (!is_numeric($_POST['wplp_favicon']) ) {
			// Add Favicon Image to Post
					$domain = preg_replace("/[^a-zA-Z0-9]+/", "", $post->post_title);
					$domain = str_replace('.','',$domain);
					$stripped = strtok($_POST['wplp_favicon'], "?");
					$image_url        = $_POST['wplp_favicon']; // Define the image URL here
					$image_name       = preg_replace("/[^a-zA-Z0-9]+/", "", $_POST['wplp_display']).'favicon';
					wplp_favicon($image_url, $image_name, $post_id);
			} elseif ( isset( $_POST['wplp_favicon'] ) && is_numeric($_POST['wplp_favicon']) ) {
				if ($mk['wplp_media_fav'] != $_POST['wplp_media_fav'] && $_POST['wplp_media_fav'] == 'true') {
					if ($mk['wplp_favicon'] != $_POST['wplp_favicon'] && $mk['wplp_media_fav'] == 'false' && !empty($mk['wplp_favicon'])) {
						wp_delete_attachment( $mk['wplp_favicon'], true );
					}
				}
				update_post_meta( $post_id, 'wplp_favicon', sanitize_text_field( $_POST['wplp_favicon'] ) );
				update_post_meta( $post_id, 'wplp_media_fav', sanitize_text_field( $_POST['wplp_media_fav'] ) );
			}
		}
	}

	if ( isset( $_POST['wplp_meta_desc'] ) ) {
		update_post_meta( $post_id, 'wplp_meta_desc', sanitize_text_field( $_POST['wplp_meta_desc'] ) );
	}

	if( isset( $_POST[ 'wplp_no_update' ] ) ) {
		update_post_meta( $post_id, 'wplp_no_update', 'no' );
		$no_update = true;
	} else {
		update_post_meta( $post_id, 'wplp_no_update', 'false' );
		$no_update = false;
	}

	if ( isset( $_POST['wplp_featured_image']) && $_POST['wplp_featured_image'] != '' && !is_numeric($_POST['wplp_featured_image']) ) {
		if ($no_update == true || $_POST['wplp_media_image'] == 'true') {
			update_post_meta( $post_id, 'wplp_no_update', 'no' );

		} else {
			if ($ss_size == 'large' ) {
				if (!empty($_POST['wplp_featured_image'])) {
					$image_url        = $_POST['wplp_featured_image']; // Define the image URL here
					$image_name       = preg_replace("/[^a-zA-Z0-9]+/", "", $_POST['wplp_display']);
					wplp_large_screenshot_quick($image_url, $image_name, $post_id);
				}
			} elseif ($ss_size == 'small') {

				if (!empty($_POST['wplp_featured_image'])) {

					// Add Featured Image to Post
					$image_name       = preg_replace("/[^a-zA-Z0-9]+/", "", $_POST['wplp_display']);
					wplp_small_screenshot($image_name, $_POST['wplp_featured_image'], $post_id);
				}

			}
		}

    } else if (isset($_POST['wplp_featured_image']) && is_numeric($_POST['wplp_featured_image']) ) {

			$post_thumbnail_id = get_post_thumbnail_id( $post_id );
		if ($mk['wplp_media_image'] != $_POST['wplp_media_image'] && $_POST['wplp_media_image'] == 'true') {
			$post_thumbnail_id = get_post_thumbnail_id( $post_id );
			if ($post_thumbnail_id != $_POST['wplp_featured_image'] && $mk['wplp_media_image'] == 'false' && !empty($post_thumbnail_id)) {
				wp_delete_attachment( $post_thumbnail_id, true );
			}
		}
		set_post_thumbnail( $post_id, $_POST['wplp_featured_image'] );
		update_post_meta( $post_id, 'wplp_media_image', sanitize_text_field( $_POST['wplp_media_image'] ) );
	} else {
		set_post_thumbnail( $post_id, '' );
	}

	if ( !isset( $mk['wplp_media_image']) && isset($_POST['wplp_media_image'] ) ) {
		update_post_meta( $post_id, 'wplp_media_image', sanitize_text_field( $_POST['wplp_media_image'] ) );
	}

	if ( !isset( $mk['wplp_media_fav'] )  && isset($_POST['wplp_media_fav']) ) {
		update_post_meta( $post_id, 'wplp_media_fav', sanitize_text_field( $_POST['wplp_media_fav'] ) );
	}

}
add_action( 'save_post', 'wplp_display_save', 10, 3 );

function wplp_delete_func( $postid ){

    global $post_type;
    if ( $post_type != 'wplp_link' ) return;

	$mk = wplp_filter_metadata( get_post_meta( $postid ) );
    $post_thumbnail_id = get_post_thumbnail_id( $postid );

	if (!empty($post_thumbnail_id) && $mk['wplp_media_image'] == 'false') {
		wp_delete_attachment( $post_thumbnail_id, true );
	}
	if (!empty($mk['wplp_favicon']) && $mk['wplp_media_fav'] == 'false') {
		wp_delete_attachment( $mk['wplp_favicon'], true );
	}
}
add_action( 'before_delete_post', 'wplp_delete_func' );

add_filter('gettext', 'wplp_text_filter', 20, 3);
/*
 * Change the text in the admin for my custom post type
 *
**/
function wplp_text_filter( $translated_text, $untranslated_text, $domain ) {

  global $typenow;

  if( is_admin() && 'wplp_link' == $typenow )  {

    //make the changes to the text
    switch( $untranslated_text ) {

        case 'Enter title here':
          $translated_text = __( 'Enter Link Url','text_domain' );
        break;

     }
   }
   return $translated_text;
}

function wplp_array_push_assoc($array, $key, $value){
$array[$key] = $value;
return $array;
}

function wplp_filter_metadata($array){
$mk = array();
foreach($array as $k => $v){
if(is_array($v) && count($v) == 1){
$mk = wplp_array_push_assoc($mk, $k, $v[0]);
} else {
$mk = wplp_array_push_assoc($mk, $k, $v);
}
}
return $mk;
}

function wplp_update_button($post_ID) {
    return '<button id="'.$post_ID.'" class="update button button-primary button-large" style="display: none;">Update Screenshot</button>';
}


function wplp_help_page() {
	?>
    <h1>Documentation</h1>
	<div class="fusion-one-half fusion-layout-column fusion-spacing-yes" style="margin-top:0px;margin-bottom:20px;"><div class="fusion-column-wrapper"><h3><strong>Installation</strong></h3>
	<h4>Uploading via WordPress Dashboard</h4>
	<ol>
	<li>Navigate to the &#8216;Add New&#8217; in the plugins dashboard</li>
	<li>Navigate to the &#8216;Upload&#8217; area</li>
	<li>Select wp-links-page.zip from your computer</li>
	<li>Click &#8216;Install Now&#8217;</li>
	<li>Activate the plugin in the Plugin dashboard</li>
	</ol>
	<h4>Using FTP</h4>
	<ol>
	<li>Download wp-links-page.zip</li>
	<li>Extract the wp-links-page.zip directory to your computer</li>
	<li>Upload the wp-links-page.zip directory to the <code>/wp-content/plugins/</code> directory</li>
	<li>Activate the plugin in the Plugin dashboard</li>
	</ol>
	</div></div><div class="fusion-one-half fusion-layout-column fusion-column-last fusion-spacing-yes" style="margin-top:0px;margin-bottom:20px;"><div class="fusion-column-wrapper"><p><img class="alignnone size-full wp-image-126" src="<?php echo plugins_url( "images/Install-Plugin.jpg", __FILE__ ); ?>" alt="Install Plugin" /></p>
	</div></div><div class="fusion-clearfix"></div><div class="fusion-sep-clear"></div><div class="fusion-separator fusion-full-width-sep sep-single" style="border-color:#e0dede;border-top-width:1px;margin-left: auto;margin-right: auto;margin-top:px;margin-bottom:30px;"></div>
	<div class="fusion-one-half fusion-layout-column fusion-spacing-yes" style="margin-top:0px;margin-bottom:20px;"><div class="fusion-column-wrapper"><h3><strong>Adding and Editing Links</strong></h3>
	<p >Visit the WP Links Page section of the dashboard to add and edit the links.</p>
	<p >Click the Add New Link button or menu item to get started.</p>
	<p >Adding a link is much like adding a Post.</p>
    <p >When adding a link, as soon as you finish entering the Link Url and then move out of that field, the screenshot and metadata will populate automatically for you. You can enter the description and add categories and tags as well.</p>
    <p>If you wish to pull the screenshot from one url but have the link go to a different address, as is the case with most affiliate links, enter the url you wish the screenshot to come from in the 'Screenshot Url' field and click 'Generate Screenshot'.</p>
    <p>Sometimes WP Links Page cannot retrieve a screenshot because a website is built with flash, has a slow loading time, or for other reasons. If you should need to use your own image instead of the automatic screenshot WP Links Page generates, simply click 'Choose Image' in the Screenshot box on the add/edit link screen and choose a new image from the media library. Should you wish to return to using a screenshot simply click 'Generate New Screenshot' which is next to 'Choose Image'.</p>
    <p>For the same reasons WP Links Page may not be able to fetch a favicon for your url. The process is similar to use your own image for a favicon. Simply click 'Set Favicon' in the Metadata box to choose a new image from the media library, and to try to retrieve the favicon again click 'Update Metadata' at the bottom of the same Metadata box. The 'Update Metadata' button will also fetch the Meta Title and Meta Description. This data does not automatically get updated as it rarely changes.</p>
    <p>You can add categories, tags, and featured images to your links in the same way you would add them to a stardard Wordpress post.</p>
    <p >To edit your links simply click the edit link inside the "All Links" page as you would with regular posts. You will be brought to the same form you used when adding your link originally. Make any changes and then click Update to save them.</p>
   </div></div><div class="fusion-one-half fusion-layout-column fusion-column-last fusion-spacing-yes" style="margin-top:0px;margin-bottom:20px;"><div class="fusion-column-wrapper"><p><img class="alignnone size-full wp-image-205" src="<?php echo plugins_url( "images/Add-New-Link.jpg", __FILE__ ); ?>" alt="add edit links" /></p>
	</div></div><div class="fusion-clearfix"></div><div class="fusion-sep-clear"></div><div class="fusion-separator fusion-full-width-sep sep-single" style="border-color:#e0dede;border-top-width:1px;margin-left: auto;margin-right: auto;margin-top:px;margin-bottom:30px;"></div>
    <div class="fusion-one-half fusion-layout-column fusion-spacing-yes" style="margin-top:0px;margin-bottom:20px;"><div class="fusion-column-wrapper"><h3><strong>All Links</strong></h3>
    <p>On the 'All Links' page you can view all of the links you have on your site.</p>
    <p>The links are sorted by their ID and should appear with the newest links first going to the oldest links.</p>
    <p>You can change the sort with filters at the top of this page, and even search for a particlular link that you need to edit.</p>
    <p>To bulk edit your links, check the boxes next to each link you wish to edit, and then choose 'Edit' from the Bulk Actions dropdown and click 'Apply'. Here you can edit categories and tags on many links at once.</p>
    <p >Clicking the ‘Update Screenshots’ button on the 'All Links' page can take several minutes depending on your connection and the amount of links you have. Please be patient while it retrieves new images. A progress bar will display to show you how much longer you may need to wait.</p>
	<br/>
	<p style="font-weight:bold">Quick Edit</p>
	<p>With the quick edit you can change the link url, link display, description, categories, order, tags, and status or each link easily.</p>
	<p><img class="alignnone size-full wp-image-205" src="<?php echo plugins_url( "images/Quck-Edit.jpg", __FILE__ ); ?>" alt="quick edit links" /></p>
    </div></div><div class="fusion-one-half fusion-layout-column fusion-column-last fusion-spacing-yes" style="margin-top:0px;margin-bottom:20px;"><div class="fusion-column-wrapper"><p><img class="alignnone size-full wp-image-205" src="<?php echo plugins_url( "images/Links List.jpg", __FILE__ ); ?>" alt="add edit links" /></p>
	</div></div><div class="fusion-clearfix"></div><div class="fusion-sep-clear"></div><div class="fusion-separator fusion-full-width-sep sep-single" style="border-color:#e0dede;border-top-width:1px;margin-left: auto;margin-right: auto;margin-top:px;margin-bottom:30px;"></div>
	<div class="fusion-one-half fusion-layout-column fusion-spacing-yes" style="margin-top:0px;margin-bottom:20px;"><div class="fusion-column-wrapper"><h3><strong>Shortcode Builder</strong></h3>
	<p >Visit the 'Shortcode' page in the WP Links Page section to create the right shortcode for your desired display.</p>
    <p>You do not need to select all options, only the options you desire. The shortcode will display using default options for all the choices you do not select.</p>
	<p>In the Display section you will choose which kind of display your links should have: Grid, List, Compact List, or Carousel.</p>
    <p>The Display Settings section will not show up until you have chosen a display, since each display has its own set of options such as the number of columns for the grid, or the number of slides to show in the carousel.<p>
    <p>In the lInk Ordering section you will choose how to sort your links.</p>
    <p>To select more than one category, simply hold down the 'Ctrl' key for PC keyboards or the 'Command' key on Mack and click each category you want to include. To select more than one tag, simply separate your tags by commas in the 'Tag' textbox.</p>
    <p>In the Image, Title, and Description sections you can decide which data to use, and how to display it. The images sizes are automatically pulled from your version of wordpress, and often your theme will create extra image sizes to use. The shortcode will automatically default to 'Medium', but you may prefer a different size. Again, you do not need to choose any options here, the display will use it's defaults.</p>
    <br />
    <p style="font-weight:bold">As you choose options on this page your shortcode will appear at the bottom of the page. This shortcode will not remain after you leave the page. Please copy and paste your shortcode before you exit the page to avoid having to build your display again.</p>
    <br />
    <p>These are the available options for the WP Links Page shortcode:</p>
    <ul>
    <li><b>'ids'</b> - You can enter any ID or comma separated list of IDs here to only display specific links. The ids are listed on the 'All Links' page in the last column of each link. The default for this field is blank. Ex: ids="1,2,3"</li>

	<li><b>'display'</b> - This is used for each display type. The options are 'grid', 'list', 'compactlist', and 'carousel'. The default for this field is 'grid'. Ex: display="grid"</li>

	<li><b>'cols'</b> - This is the number of columns your grid should have. You can enter any number into this field, but 2, 3, 4, 5, and 6 are recommended. The default for this field is '3'. Ex: cols="3"</li>

    <li><b>'slides'</b> - This is the number of slides to show at a time in the carousel. You can enter any number into this field. The default for this field is '3'. Ex: slides="3"</li>

	<li><b>'slide_scroll'</b> - This is the number of slides to scroll at a time when clicking the next button on the carousel. You can set this to any number or 'all' which will scroll the same number as the slides option. The default for this field is '1'. Ex: slide_scroll="1"</li>

	<li><b>'autoplay'</b> - This is whether to automatically scroll the carousel. The options are 'true' to let the carousel scroll on load, or 'false' to only scroll when clicked. This defaults to 'true'. Ex: autoplay="true"</li>

	<li><b>'infinite'</b> - THis is whether or not to loop the slides in the carousel. The options are 'true' to restart the slides after the end, or 'false' to end the carousel with the last slide. This defaults to 'true'. Ex: infinite="true"</li>

	<li><b>'pager'</b> - This selects the type of pager to use for your links if you have too many to show on one page. The options are "pagination" to use standard page numbers as in Wordpress, "view_more" to add a View More button at the end of your links which will load more links, "infinite" to automatically load more links as soon as the visitor scrolls to the bottom of the page, and to leave it blank for no pager. The default for this field is 'pagination'. Ex: pager="pagination"</li>

	<li><b>'load_more'</b> - This is used as the text in the View More button at the end of the 'view_more' pager. The default is 'Load More'. Ex: load_more="Load More"</li>

	<li><b>'num'</b> - This is the number of links to display. If you are using a pager, this means per page.  To show all links without a pager use 'all'. The default will use the 'Blog pages allow at most' option, found in Settings > Reading, as the number per page for List and Compact List, and the number of rows per page for Grid. Carousel does not use a pager and will be limited to this setting by default. Ex: num="30"</li>

	<li><b>'orderby'</b> - This is used to sort the links differently. This accepts most common WP_Query orderby arguments <a href="https://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">which can be found here</a>. The only exception is if you want to sort by the url of your link use 'post_title' in this field, and 'title' for Link Display. This field defaults to 'ID'. Ex: orderby="ID"</li>

    <li><b>'order'</b> - This is whether to sort ascending 'ASC' or descending 'DESC'. The default is 'DESC'. Ex: order="DESC"</li>

	<li><b>'cat'</b> - This will let you display only those links contained in specific categories. You will need to enter the category ids here for it to work properly. This is blank by default. Ex: cat="3,23,32"</li>

	<li><b>'tag'</b> - This will let you display only links that have a certain tag. You can enter tag ids. This is blank by default. Ex: tag="45,46"</li>

	<li><b>'image'</b> - This decides which image to use in your display. The options are 'ss' for screenshot, or 'fav' for favicon. This field defaults to 'ss'. Ex: image="ss"</li>

	<li><b>'img_size'</b> - This is what size of image to use in your display. The options vary from site to site, but the default, 'medium', is one of the standard wordpress sizes. For a full list of your image sizes available visit the 'Shortcode' page. Ex: img_size="medium"</li>

	<li><b>'img_style'</b> - This field will add css to the images. You can place any valid CSS here and it will be applied to your image. This is blank by default. Ex: img_style="box-shadow: 0 5px 10px 0 rgba(0,0,0,0.2),0 5px 15px 0 rgba(0,0,0,0.19);"</li>

	<li><b>'title'</b> - This lets you choose which title to use in your display. Your options are either 'display' which is the Link Display, or 'meta' which is the Meta Title. This defaults to 'display'. Ex: title="display"</li>

	<li><b>'title_style'</b> - This field will add css to the titles. You can place any valid CSS here and it will be applied to your title. This is blank by default. Ex: title_style="font-color: #ccc;"</li>

	<li><b>'desc'</b> - This lets you choose which description to use in your display. Your options are either 'content' which is the Description, or 'meta' which is the Meta Description. You can also use 'none' or simply leave this field blank to display no description. This defaults to 'none'. Ex: desc="content"</li>

	<li><b>'desc_style'</b> - This field will add css to the descriptions. You can place any valid CSS here and it will be applied to your description. This is blank by default. Ex: desc_style="font-style: italic;"</li>
    </ul>
	<br/>
	<p style="font-weight:bold">Copy and paste your shortcode in a post or page to display your links before you exit the page to avoid having to build your display again.</p>
	<br/>
	<p><img class="alignnone size-full wp-image-110" src="<?php echo plugins_url( "images/Page-Post.jpg", __FILE__ ); ?>" alt="page post" /></p>
    </div></div><div class="fusion-one-half fusion-layout-column fusion-column-last fusion-spacing-yes" style="margin-top:0px;margin-bottom:20px;"><div class="fusion-column-wrapper"><p><img class="alignnone size-full wp-image-110" src="<?php echo plugins_url( "images/Shortcodes.jpg", __FILE__ ); ?>" alt="settings page" /></p>
	</div></div><div class="fusion-clearfix"></div><div class="fusion-sep-clear"></div><div class="fusion-separator fusion-full-width-sep sep-single" style="border-color:#e0dede;border-top-width:1px;margin-left: auto;margin-right: auto;margin-top:px;margin-bottom:30px;"></div>
	<div class="fusion-one-half fusion-layout-column fusion-spacing-yes" style="margin-top:0px;margin-bottom:20px;"><div class="fusion-column-wrapper"><h3><strong>Settings</strong></h3>
	<p >On the 'Settings' page you have various options for your Links.</p>
    <p>For anyone who used an older version of WP Links Page you will see the 'Update Your Links' section. By clicking 'Update Links' here WP Links Page will automatically import your links from the older version. A progressbar will be displayed while the update is happening. Once finished it will notify you of any errors or if all links were updated successfully. It will not delete them from the old version, should you choose to revert to that version at a later date.</p>
    <p>The Screenshot size option allows you to choose which size of screenshot to retrieve. This is actually a choice between two different screenshot API's to use. The 500px Width uses a Google API and is in our opinion very reliable. However, the images are small. The 1200px Width uses a Wordpress API that is a little less reliable, but most sites work very well with this API.</p>
    <p>The Default Favicon field is used when you are displaying links with their favicon image, but a certain link didn't import a favicon. By setting the default image here, this image will display instead of having an empty slot in your display.</p>
    <p>The screenshot refresh rate is how often to generate new screenshots. The options are: Never, Twice Daily, Daily, Every two days, Weekly, Every two Weeks, Monthly.</p>
	<p>NOTE: If you have 100's of links or limited server resources consider using a monthly refresh rate or not refreshing automatically. </p>
    <p>The Role Capabilities Section allows you to limit the use of WP Links Page to specific users only based on their user role.</p>
	<p>The Import Links feature allows you to import links from any comma separated list of urls. Simply paste your list of links into the 'Links' textarea, add a category if you want, and then press 'Import' at the bottom of the page. A progress bar will display, and when finished import it will notify you of any errors or if all links were imported successfully.</p>
	<p>NOTE: The amount of links you can import at a time will be determined by your server resources.</p>
	</div></div><div class="fusion-one-half fusion-layout-column fusion-column-last fusion-spacing-yes" style="margin-top:0px;margin-bottom:20px;"><div class="fusion-column-wrapper"><p><img class="alignnone wp-image-184 size-full" src="<?php echo plugins_url( "images/Settings.jpg", __FILE__ ); ?>" alt="Shortcode Example" /></p>
	</div></div><div class="fusion-clearfix"></div><div class="fusion-sep-clear"></div><div class="fusion-separator fusion-full-width-sep sep-single" style="border-color:#e0dede;border-top-width:1px;margin-left: auto;margin-right: auto;margin-top:px;margin-bottom:30px;"></div>

	<a href="http://www.wplinkspage.com/" target="_blank">For more information please visit us at wplinkspage.com</a>

	<?php
}

function wplp_shortcode_page() {
	?>
		<h2>Shortcodes</h2>
		<p class="description">Here you can generate shortcode based on the options you choose.</p>

        <div id="wplp-sb">
  <div id="tabs-1" aria-labelledby="ui-id-1">
    <h3>Display</h3>
    <hr style="border: 1px solid; width: 50%;" align="left">
    <div class="radio-i">
  	<p>Which display would you like to use?</p>
    <label><input name="wplp-display" value="grid" type="radio"><i class="ti-size-xxl ti-layout-grid3-alt"></i><br><span>Grid</span></label>
  	<label><input name="wplp-display" value="list" type="radio"><i class="ti-size-xxl ti-layout-list-thumb-alt"></i><br><span>List</span></label>
  	<label><input name="wplp-display" value="compactlist" type="radio"><i class="ti-size-xxl ti-list"></i><br><span>Compact List</span></label>
  	<label><input name="wplp-display" value="carousel" type="radio"><i class="ti-size-xxl ti-layout-slider"></i><br><span>Carousel</span></label>
    </div>
  </div>
  <br><br>
  <div id="tabs-2">
  <h3>Display Settings</h3>
  <hr style="border: 1px solid; width: 50%;" align="left">
  <p class="description">Choose a display above to see the settings available for that display.</p>
  <div class="grid radio-no-i">
  	<p>How many columns should your grid have?</p>
    <label><input type="radio" name="wplp-columns" value="2"><br><span>2 Columns</span></label>
  	<label><input type="radio" name="wplp-columns" value="3"><br><span>3 Columns</span></label>
  	<label><input type="radio" name="wplp-columns" value="4"><br><span>4 Columns</span></label>
  	<label><input type="radio" name="wplp-columns" value="5"><br><span>5 Columns</span></label>
  	<label><input type="radio" name="wplp-columns" value="6"><br><span>6 Columns</span></label>
    <br>
 </div>
  <div class="not-carousel">
    <p>How many links per page?</p>
    <label><input name="wplp-num" type="text"></label><br>
    <br>
  <div class="radio-no-i paging">
    <p>What kind of pagination do you want to use?</p>
    <label><input type="radio" name="wplp-paging" value="pagination"><br><span>Pagination</span></label>
  	<label><input type="radio" name="wplp-paging" value="view_more"><br><span>View More</span></label>
  	<label><input type="radio" name="wplp-paging" value="infinite"><br><span>Infinite Scroll</span></label>
  	<label><input type="radio" name="wplp-paging" value="none"><br><span>None</span></label>
    <br>
  </div>
  <div class="view-more">
    <p>What do you want the View More button to say?</p>
    <label><input name="wplp-load-more" value="View More" type="text"></label><br>
    <br>
  </div>
  </div>
  <div class="carousel">
    <p>How many links in total?</p>
    <label><input name="wplp-num-car" type="text"></label><br>
    <br>
  <div class="radio-no-i">
    <p>How many slides would you like to show at a time?</p>
    <label><input type="radio" name="wplp-slides" value="1"><br><span>1</span></label>
  	<label><input type="radio" name="wplp-slides" value="2"><br><span>2</span></label>
  	<label><input type="radio" name="wplp-slides" value="3"><br><span>3</span></label>
  	<label><input type="radio" name="wplp-slides" value="4"><br><span>4</span></label>
  	<label><input type="radio" name="wplp-slides" value="5"><br><span>5</span></label>
  	<label><input type="radio" name="wplp-slides" value="6"><br><span>6</span></label>
    <br>
    <div>
    <p>How many should move at a time?</p>
    <label><input type="radio" name="wplp-slide-scroll" value="1"><br><span>1</span></label>
  	<label><input type="radio" name="wplp-slide-scroll" value="all"><br><span>All of them</span></label>
    <br>
    <div>
    <p>Should the carousel scroll automatically or only when clicked?</p>
    <label><input type="radio" name="wplp-autoplay" value="true"><br><span>Auto Play</span></label>
  	<label><input type="radio" name="wplp-autoplay" value="false"><br><span>Click to Scroll</span></label>
    <br>
    <div>
    <p>Should the carousel loop or end when scrolling?</p>
    <label><input type="radio" name="wplp-infinite" value="true"><br><span>Loop</span></label>
  	<label><input type="radio" name="wplp-infinite" value="false"><br><span>End</span></label>
    </div></div></div>
  </div>
  </div>
  </div>
  <br><br>
  <div id="tabs-3">
  <h3>Link Ordering</h3>
  <hr style="border: 1px solid; width: 50%;" align="left">
  <div class="radio-no-i">
  	<p>How do you want to sort your links?</p>
  	<label><input type="radio" name="wplp-order" value="title"><br><span>By Title (Link Display)</span></label>
  	<label><input type="radio" name="wplp-order" value="ID"><br><span>By Link ID</span></label>
  	<label><input type="radio" name="wplp-order" value="date"><br><span>By Date</span></label>
  	<label><input type="radio" name="wplp-order" value="rand"><br><span>Random</span></label>
    <br>
   <div>
  	<p>Should they be descending or ascending?</p>
  	<label><input type="radio" name="wplp-orderby" value="ASC"><br><span>Ascending</span></label>
  	<label><input type="radio" name="wplp-orderby" value="DESC"><br><span>Descending</span></label>
    <br>
  </div>
  <br>
  <h3>Filter and Search</h3>
	<hr style="border: 1px solid; width: 50%;" align="left">
  	<p>Do you want to filter the links by category?</p>

    <label for="wplp-category">Category: </label><br><?php
	$args = array(
		'show_option_all'    => '',
		'show_option_none'   => 'Select a Category',
		'option_none_value'  => '-1',
		'orderby'            => 'name',
		'order'              => 'ASC',
		'show_count'         => 0,
		'hide_empty'         => 0,
		'child_of'           => 0,
		'exclude'            => '',
		'include'            => '',
		'echo'               => 1,
		'selected'           => 0,
		'hierarchical'       => 1,
		'name'               => 'cat',
		'id'                 => '',
		'class'              => 'postform',
		'depth'              => 100,
		'tab_index'          => 0,
		'taxonomy'           => 'wplp_link_category',
		'hide_if_empty'      => false,
		'value_field'	     => 'term_id',
	);
	wp_dropdown_categories($args);
	?>
     <p class="description">Hold down the Ctrl Key on PC, or the Command Key on Mac to select more than one category.</p>
     <p>Do you want to filter the links by tag(s)?</p>
     <label for="wplp-tag">Tags: </label><br><?php
	$args = array(
		'show_option_all'    => '',
		'show_option_none'   => 'Select Tag(s)',
		'option_none_value'  => '-1',
		'orderby'            => 'name',
		'order'              => 'ASC',
		'show_count'         => 0,
		'hide_empty'         => 0,
		'child_of'           => 0,
		'exclude'            => '',
		'include'            => '',
		'echo'               => 1,
		'selected'           => 0,
		'hierarchical'       => 0,
		'name'               => 'tag',
		'id'                 => '',
		'class'              => 'postform',
		'depth'              => 100,
		'tab_index'          => 0,
		'taxonomy'           => 'wplp_tag',
		'hide_if_empty'      => false,
		'value_field'	     => 'term_id',
	);
	wp_dropdown_categories($args);
	?>
     <p class="description">Hold down the Ctrl Key on PC, or the Command Key on Mac to select more than one category.</p>
  </div>
  <br><br>
  <div id="tabs-4">
  <h3>Image</h3>
  <hr style="border: 1px solid; width: 50%;" align="left">
  <div class="radio-no-i">
  	<p>What image should this display use?</p>
    <label><input type="radio" name="wplp-image" value="ss"><br><span>Screenshot</span></label>
  	<label><input type="radio" name="wplp-image" value="fav"><br><span>Favicon</span></label>
    <br>
    <div>
  	<p>What size of image should this display use?</p>
    <?php
	$sizes = get_intermediate_image_sizes();

	foreach($sizes as $size) {
		echo '<label><input type="radio" name="wplp-image-size" value="'.$size.'"><br><span>'.ucwords($size).'</span></label>
		';
	}

	?>
  	<label><input type="radio" name="wplp-image-size" value="full"><br><span>Original</span></label>
    <br>
    </div></div><div class="checks">
  	<p>Should the image be styled?</p>
    <label><input type="checkbox" name="wplp-image-style" value="border"><br><span>Border</span></label>
  	<label><input type="checkbox" name="wplp-image-style" value="shadow"><br><span>Shadow</span></label>
  </div></div>
  <br><br>
  <div id="tabs-5" >
  <h3>Title</h3>
  <hr style="border: 1px solid; width: 50%;" align="left">
  <div class="radio-no-i">
  	<p>What title should this display use?</p>
    <label><input type="radio" name="wplp-title" value="display"><br><span>Link Display</span></label>
  	<label><input type="radio" name="wplp-title" value="meta"><br><span>Meta Title</span></label>
    <br>
    </div><div class="checks">
  	<p>Should the title be styled?</p>
    <label><input type="checkbox" name="wplp-title-style" value="bold"><br><span>Bold</span></label>
  	<label><input type="checkbox" name="wplp-title-style" value="italic"><br><span>Italic</span></label>
  	<label><input type="checkbox" name="wplp-title-style" value="underline"><br><span>Underline</span></label>
    <br>
    </div><div class="radio-no-i">
  	<p>How should the title be aligned?</p>
    <label><input type="radio" name="wplp-title-align" value="left"><br><span>Left</span></label>
  	<label><input type="radio" name="wplp-title-align" value="right"><br><span>Right</span></label>
  	<label><input type="radio" name="wplp-title-align" value="center"><br><span>Center</span></label>
    <br>
  </div>
  	<p>Do you want to change the font-size?</p>
    <label for="wplp-title-size">Font size: </label><input name="wplp-title-size" type="text"> px<br>
  </div>
  <br><br>
  <div id="tabs-6" >
  <h3>Description</h3>
  <hr style="border: 1px solid; width: 50%;" align="left">
  <div class="radio-no-i">
  	<p>What description should this display use?</p>
    <label><input type="radio" name="wplp-desc" value="content"><br><span>Link Description</span></label>
  	<label><input type="radio" name="wplp-desc" value="meta"><br><span>Meta Description</span></label>
  	<label><input type="radio" name="wplp-desc" value="none"><br><span>None</span></label><br>
    <br>
    </div><div class="checks">
  	<p>Should the description be styled?</p>
    <label><input type="checkbox" name="wplp-desc-style" value="bold"><br><span>Bold</span></label>
  	<label><input type="checkbox" name="wplp-desc-style" value="italic"><br><span>Italic</span></label>
  	<label><input type="checkbox" name="wplp-desc-style" value="underline"><br><span>Underline</span></label>
    <br>
    </div><div class="radio-no-i">
  	<p>How should the description be aligned?</p>
    <label><input type="radio" name="wplp-desc-align" value="left"><br><span>Left</span></label>
  	<label><input type="radio" name="wplp-desc-align" value="right"><br><span>Right</span></label>
  	<label><input type="radio" name="wplp-desc-align" value="center"><br><span>Center</span></label>
    <br>
	 </div><div class="radio-no-i">
  	<p>Would you link the description to be Linked?</p>
    <label><input type="radio" name="wplp-description_link" value="no"><br><span>No</span></label>
  	<label><input type="radio" name="wplp-description_link" value="yes"><br><span>Yes</span></label>
    <br>
  </div>
  	<p>Do you want to change the font-size?</p>
    <label for="wplp-desc-size">Font size: </label><input name="wplp-desc-size" type="text"><br>
  </div>
</div>
<div class="wplp-shortcode">
<p>Your Shortcode</p>
	<textarea id="final-shortcode">[wp_links_page]</textarea>
</div>
<div class="clear">
</div>
    <?php
}

function wplp_subpage_options() {

		if (isset($_GET['settings-updated']) && $_GET['settings-updated']) {
			$sr = get_option('wplp_screenshot_refresh');
			$timestamp = time();
			if ($sr == 'twicedaily') {$rate = '+12 hours';}
			if ($sr == 'daily') {$rate = '+1 day';}
			if ($sr == 'twodays') {$rate = '+2 days';}
			if ($sr == 'threedays') {$rate = '+3 days';}
			if ($sr == 'weekly') {$rate = '+1 week';}
			if ($sr == 'biweekly') {$rate = '+2 weeks';}
			if ($sr == 'monthly') {$rate = '+1 month';}
			if ($sr == 'never') {
				wp_clear_scheduled_hook( 'wp_links_page_event' );
			} else {
				$exists = wp_get_schedule( 'wp_links_page_event' );
				if ($exists == false) {
					wp_schedule_event(time(), $sr, 'wp_links_page_event');
				} else {
				$next_event = strtotime($rate, $timestamp);
				$time = wp_next_scheduled( 'wp_links_page_event' );
				wp_clear_scheduled_hook( 'wp_links_page_event' );
				wp_schedule_event( $next_event, $sr, 'wp_links_page_event' );
				}
			}
		}
    	$apikey = esc_attr( get_option('wplp_apikey'));
		echo '<div class="wrap wplp-settings">
		<h1>WP Links Page Pro Settings</h1>';
		echo '<form method="post" action="options.php">';
		settings_fields( 'wp-links-page-option-group' );
		do_settings_sections( 'wp-links-page-option-group' );


		$default_id = esc_attr( get_option('wplp_default_favicon'));
		if ($default_id == 'false') {
			$default = plugins_url( '/images/default-favicon.ico', __FILE__ );
		} else {
			$default = wp_get_attachment_url( $default_id );
		}
		$screenshot_size = esc_attr( get_option('wplp_screenshot_size') );
		$screenshot_refresh = esc_attr( get_option('wplp_screenshot_refresh') );
		$role = esc_attr( get_option('wplp_role') );

		echo '<table class="form-table"><tbody>
		<tr>
			<th scope="row" class="screenshot"><label class="label" for="wplp_screenshot_size" >Screenshot Size</label></th>
	        <td class="screenshot">
			<label><input type="radio" name="wplp_screenshot_size" value="small" ';
		echo ($screenshot_size=='small')?'checked':'';
		echo ' >500px Width</label><br>
			<label><input type="radio" name="wplp_screenshot_size" value="large" ';
		echo ($screenshot_size=='large')?'checked':'';
		echo ' >1200px Width</label><br/>';
		if ($screenshot_size == 'small') {$screenshot_size = '500px Width';}
		if ($screenshot_size == 'large') {$screenshot_size = '1200px Width';}
		echo '<p class="description">What size of screenshots should WP Links Page retrieve?<br/>The screenshot size is currently set to '.$screenshot_size.'.</p></td></tr>';
		echo '';

if ($screenshot_size == '500px Width') {
    echo '<tr>
      <th scope="row"><label class="label" for="wplp_apikey" >Optional: Google PageSpeed Insights API key</label></th>
      <td>
      <label>
    <input id="wplp_apikey" type="text" name="wplp_apikey" value="'.$apikey.'" />';
    echo '<p class="description">If you are having trouble updating your links, enter a Google PageSpeed Insights API Key here. <a href="https://developers.google.com/speed/docs/insights/v5/get-started">Get an API key here.</a><p>Your current API is '.$apikey.'.</p></td></tr>';
}

		echo '<tr>
			<th scope="row"><label class="label" for="wplp_default_favicon" >Default Favicon</label></th>
	        <td>
			<label><img class="wplp_favicon" src="'.$default.'" />
		<input id="wplp_favicon" type="hidden" name="wplp_default_favicon" value="'.$default_id.'" />
		<p class="hide-if-no-js">
		<a id="set-favicon" class="set-favicon button button-large" href="#" title="Set Default Favicon">Set Default Favicon</a>
		</p></div>
</div>';
		echo '<p class="description">What image should WP Links Page use if it cannot retrieve the favicon? The image shown above is the current default.</p></td></tr>';
		echo '<tr>
			<th scope="row" class="screenshot" ><label class="label" for="wplp_screenshot_refresh" >Screenshot Refresh Rate</label></th>
	        <td class="screenshot" >
			<label><input type="radio" name="wplp_screenshot_refresh" value="never" data-current="'.$screenshot_refresh.'" ';
		echo ($screenshot_refresh=='never')?'checked':'';
		echo ' >Never</label><br/>
			<label><input type="radio" name="wplp_screenshot_refresh" value="twicedaily" ';
		echo ($screenshot_refresh=='twicedaily')?'checked':'';
		echo ' >Twice Daily</label><br/>
			<label><input type="radio" name="wplp_screenshot_refresh" value="daily" ';
		echo ($screenshot_refresh=='daily')?'checked':'';
		echo ' >Daily</label><br/>
			<label><input type="radio" name="wplp_screenshot_refresh" value="twodays" ';
		echo ($screenshot_refresh=='twodays')?'checked':'';
		echo ' >Every Two Days</label><br/>
			<label><input type="radio" name="wplp_screenshot_refresh" value="threedays" ';
		echo ($screenshot_refresh=='threedays')?'checked':'';
		echo ' >Every Three Days</label><br/>
			<label><input type="radio" name="wplp_screenshot_refresh" value="weekly" ';
		echo ($screenshot_refresh=='weekly')?'checked':'';
		echo ' >Weekly</label><br/>
			<label><input type="radio" name="wplp_screenshot_refresh" value="biweekly" ';
		echo ($screenshot_refresh=='biweekly')?'checked':'';
		echo ' >Every Two Weeks</label><br/>
			<label><input type="radio" name="wplp_screenshot_refresh" value="monthly" ';
		echo ($screenshot_refresh=='monthly')?'checked':'';
		echo ' >Monthly</label><br/>';
		if ($screenshot_refresh == 'never') {$screenshot_refresh = 'Never';}
		if ($screenshot_refresh == 'twicedaily') {$screenshot_refresh = 'Twice Daily';}
		if ($screenshot_refresh == 'daily') {$screenshot_refresh = 'Daily';}
		if ($screenshot_refresh == 'twodays') {$screenshot_refresh = 'Two Days';}
		if ($screenshot_refresh == 'threedays') {$screenshot_refresh = 'Every Three Days';}
		if ($screenshot_refresh == 'weekly') {$screenshot_refresh = 'Weekly';}
		if ($screenshot_refresh == 'biweekly') {$screenshot_refresh = 'Every Two Weeks';}
		if ($screenshot_refresh == 'monthly') {$screenshot_refresh = 'Monthly';}
		echo '<p class="description">How often should WP Links Page get new screenshots for your links?<br/>The refresh rate is currently set to '.$screenshot_refresh.'.</p></td></tr>';
		echo '<tr>
			<th scope="row" class="role" ><label class="label" for="wplp_role" >Role Capabilities</label></th>
	        <td class="roles" >
			<label><input type="radio" name="wplp_role" value="administrator" data-current="'.$role.'" ';
		echo ($role=='administrator')?'checked':'';
		echo ' >Administrator</label><br/>
			<label><input type="radio" name="wplp_role" value="editor" ';
		echo ($role=='editor')?'checked':'';
		echo ' >Editor</label><br/>
			<label><input type="radio" name="wplp_role" value="author" ';
		echo ($role=='author')?'checked':'';
		echo ' >Author</label><br/>
			<label><input type="radio" name="wplp_role" value="contributor" ';
		echo ($role=='contributor')?'checked':'';
		echo ' >Contributor</label><br/>
			<label><input type="radio" name="wplp_role" value="subscriber" ';
		echo ($role=='subscriber')?'checked':'';
		echo ' >Subscriber</label><br/>';
		$role = ucfirst($role);
		echo '<p class="description">What User Roles should be able to use WP Links Page?<br/>The current user role is '.$role.'.</p></td></tr>';
		echo '</td></tr></tbody></table>';
		submit_button();
		echo '</form><hr><h3> Import Links</h3>';
			echo '<p class="description" >This form allows you to import links from a comma separated list of urls. Simply paste your list of urls into the textbox below and click import.</p> <p>NOTE: The amount of links you can import at a time will be determined by your server resources.</p>
			<table class="form-table"><tbody>
			<tr><th scope="row"><label class="label" for="wplp_link_list" >Links</label></th>
	        <td>';
			echo '<textarea name="wplp_link_list" class="large-text" rows="10" ></textarea>
			</td></tr>
			<tr><th scope="row"><label class="label" for="wplp_link_cat" >Category</label></th>
	        <td>
			<input name="wplp_link_cat" class="regular-text ltr" type="text" value="" />
			<br/>
			<p class="description">Optionally add your imported links to a category.</p>
			</td>
			<tr><th scope="row"></th>
	        <td>
			<a id="wplp_import_links" href="#" class="button" style="float:left; margin-right: 20px;">Import</a>
			<div id="progressbar1"><div class="progress-label1 progress-label"></div></div>
			<p class="error import" data-total=""></p>
			<p class="success import" data-total=""></p>

			</td></tr></tbody></table>
	    </div>';
	}

	function wp_links_page_settings() { // whitelist options
		register_setting( 'wp-links-page-option-group', 'wplp_screenshot_size' );
		register_setting( 'wp-links-page-option-group', 'wplp_screenshot_refresh' );
		register_setting( 'wp-links-page-option-group', 'wplp_role' );
		register_setting( 'wp-links-page-option-group', 'wplp_default_favicon' );
		register_setting( 'wp-links-page-option-group', 'wplp_apikey' );
	}

	function wplp_large_screenshot($image_url, $image_name, $post_id) {
		// Add Featured Image to Post
		$upload_dir       = WPLP_UPLOAD_DIR; // Set upload folder
		$unique_file_name = wp_unique_filename( $upload_dir, $image_name ); // Generate unique name
		$filename         = basename( $unique_file_name ); // Create image file name


		// Save as a temporary file
		$down_url = $image_url . '.jpg';
    $tmp1 = download_url( $down_url );
    @unlink($tmp1);
    sleep(15);
		$tmp = download_url( $down_url );

		// Check for download errors
		if ( is_wp_error( $tmp ) )
		{
			@unlink( $file_array[ 'tmp_name' ] );
			return $tmp;
		}

		$img_url = WPLP_UPLOAD_URL.$image_name.".jpg";

		$file = WPLP_UPLOAD_DIR . $image_name . '.jpg';


		// Take care of image files without extension:
		$path = pathinfo( $tmp );
		if( ! isset( $path['extension'] ) ):
			$tmpnew = $tmp . '.jpg';
			if( ! rename( $tmp, $tmpnew ) ):
				return '';
			else:
				$name = $filename.'.jpg';
				$tmp = $tmpnew;
			endif;
		endif;
		if( $path['extension'] == 'tmp' ):
			$tmpnew = $path['dirname'].'/'.$path['filename'] . '.jpg';
			if( ! rename( $tmp, $tmpnew ) ):
				return '';
			else:
				$name = $filename.'.jpg';
				$tmp = $tmpnew;
			endif;
		endif;


		$file = WPLP_UPLOAD_DIR . $filename . time() . '.jpg';
		$move = rename($tmp, $file);


		// Check image file type
		$wp_filetype = wp_check_filetype( $file, null );

		// Set attachment data
		$attachment = array(
			'post_mime_type' => $wp_filetype['type'],
			'post_title'     => sanitize_file_name( $filename ),
			'post_content'   => '',
			'post_status'    => 'inherit'
		);

		// Create the attachment
		$attach_id = wp_insert_attachment( $attachment, $file, $post_id );

		// Include image.php
		require_once(ABSPATH . 'wp-admin/includes/image.php');

		// Define attachment metadata
		$attach_data = wp_generate_attachment_metadata( $attach_id, $file );

		// Assign metadata to attachment
		wp_update_attachment_metadata( $attach_id, $attach_data );

		// Get current screenshot ID and delete if it exists
		$post_thumbnail_id = get_post_thumbnail_id( $post_id );
		$mk = wplp_filter_metadata( get_post_meta( $post_id ) );
		if (!empty($post_thumbnail_id) && $mk['wplp_media_image'] != 'true') {
			wp_delete_attachment( $post_thumbnail_id, true );
		}

		// And finally assign featured image to post
		set_post_thumbnail( $post_id, $attach_id );
		update_post_meta( $post_id, 'wplp_media_image', 'false');

    @unlink( $tmp );
		return 'success';
	}

  function wplp_large_screenshot_quick($image_url, $image_name, $post_id) {
		// Add Featured Image to Post
		$upload_dir       = WPLP_UPLOAD_DIR; // Set upload folder
		$unique_file_name = wp_unique_filename( $upload_dir, $image_name ); // Generate unique name
		$filename         = basename( $unique_file_name ); // Create image file name


		// Save as a temporary file
		$down_url = $image_url . '.jpg';
		$tmp = download_url( $down_url );

		// Check for download errors
		if ( is_wp_error( $tmp ) )
		{
			@unlink( $file_array[ 'tmp_name' ] );
			return $tmp;
		}

		$img_url = WPLP_UPLOAD_URL.$image_name.".jpg";

		$file = WPLP_UPLOAD_DIR . $image_name . '.jpg';


		// Take care of image files without extension:
		$path = pathinfo( $tmp );
		if( ! isset( $path['extension'] ) ):
			$tmpnew = $tmp . '.jpg';
			if( ! rename( $tmp, $tmpnew ) ):
				return '';
			else:
				$name = $filename.'.jpg';
				$tmp = $tmpnew;
			endif;
		endif;
		if( $path['extension'] == 'tmp' ):
			$tmpnew = $path['dirname'].'/'.$path['filename'] . '.jpg';
			if( ! rename( $tmp, $tmpnew ) ):
				return '';
			else:
				$name = $filename.'.jpg';
				$tmp = $tmpnew;
			endif;
		endif;


		$file = WPLP_UPLOAD_DIR . $filename . time() . '.jpg';
		$move = rename($tmp, $file);


		// Check image file type
		$wp_filetype = wp_check_filetype( $file, null );

		// Set attachment data
		$attachment = array(
			'post_mime_type' => $wp_filetype['type'],
			'post_title'     => sanitize_file_name( $filename ),
			'post_content'   => '',
			'post_status'    => 'inherit'
		);

		// Create the attachment
		$attach_id = wp_insert_attachment( $attachment, $file, $post_id );

		// Include image.php
		require_once(ABSPATH . 'wp-admin/includes/image.php');

		// Define attachment metadata
		$attach_data = wp_generate_attachment_metadata( $attach_id, $file );

		// Assign metadata to attachment
		wp_update_attachment_metadata( $attach_id, $attach_data );

		// Get current screenshot ID and delete if it exists
		$post_thumbnail_id = get_post_thumbnail_id( $post_id );
		$mk = wplp_filter_metadata( get_post_meta( $post_id ) );
		if (!empty($post_thumbnail_id) && $mk['wplp_media_image'] != 'true') {
			wp_delete_attachment( $post_thumbnail_id, true );
		}

		// And finally assign featured image to post
		set_post_thumbnail( $post_id, $attach_id );
		update_post_meta( $post_id, 'wplp_media_image', 'false');

    @unlink( $tmp );
		return 'success';
	}

	function wplp_small_screenshot_url($image_name, $url, $post_id) {
		$apikey = esc_attr( get_option('wplp_apikey'));
		$screenshot = file_get_contents('https://pagespeedonline.googleapis.com/pagespeedonline/v5/runPagespeed?url='.$url."&key=".$apikey);
		$data_whole = json_decode($screenshot);

		if (isset($data_whole->error) || empty($screenshot)) {
			if (!(substr($url, 0, 4) == 'http')) {
				$url2 = 'https%3A%2F%2F' . $url;
				$screenshot = file_get_contents('https://pagespeedonline.googleapis.com/pagespeedonline/v5/runPagespeed?url='.$url2."&key=".$apikey);
				$data_whole = json_decode($screenshot);
			}
		}
		if (isset($data_whole->error) || empty($screenshot)) {
			if (!(substr($url, 0, 3) == 'www')) {
				$url3 = 'https%3A%2F%2F' . 'www.' . $url;
				$screenshot = file_get_contents('https://pagespeedonline.googleapis.com/pagespeedonline/v5/runPagespeed?url='.$url3."&key=".$apikey);
				$data_whole = json_decode($screenshot);
			}
		}
		if (isset($data_whole->error)) {
				die(json_encode(array('message' => 'ERROR', 'code' => 'data returned error')));
		}
    if (isset($data_whole->lighthouseResult->audits->{'final-screenshot'}->details->data)) {
			$data = $data_whole->lighthouseResult->audits->{'final-screenshot'}->details->data;
      $data = str_replace('data:image/jpeg;base64','',$data);
		} else {
		die(json_encode(array('message' => 'ERROR', 'code' => 'no screenshot')));}
		$data = str_replace('_', '/', $data);
		$data = str_replace('-', '+', $data);
		$base64img = str_replace('data:image/jpeg;base64,', '', $data);

		$data   		  = base64_decode($data);
		$upload_dir       = WPLP_UPLOAD_DIR; // Set upload folder
		$image_data       = $data; // img data
		$unique_file_name = wp_unique_filename( $upload_dir, $image_name ); // Generate unique name
		$filename         = basename( $unique_file_name ); // Create image file name


		$tmp = WPLP_UPLOAD_DIR . $image_name . '.jpg';
		// Create the image  file on the server
		file_put_contents( $tmp, $image_data );

		$exists = file_exists($tmp);
		if ($exists == true) {
			$file = WPLP_UPLOAD_DIR . $filename . time() . '.jpg';
		}
		$move = rename($tmp, $file);


		// Check image file type
		$wp_filetype = wp_check_filetype( $file, null );

		// Set attachment data
		$attachment = array(
			'post_mime_type' => $wp_filetype['type'],
			'post_title'     => sanitize_file_name( $filename ),
			'post_content'   => '',
			'post_status'    => 'inherit'
		);

		// Create the attachment
		$attach_id = wp_insert_attachment( $attachment, $file, $post_id );

		// Include image.php
		require_once(ABSPATH . 'wp-admin/includes/image.php');

		// Define attachment metadata
		$attach_data = wp_generate_attachment_metadata( $attach_id, $file );

		// Assign metadata to attachment
		wp_update_attachment_metadata( $attach_id, $attach_data );

		// Get current screenshot ID and delete if it exists
		$post_thumbnail_id = get_post_thumbnail_id( $post_id );
		$mk = wplp_filter_metadata( get_post_meta( $post_id ) );
		if (!empty($post_thumbnail_id) && $mk['wplp_media_image'] != 'true') {
			wp_delete_attachment( $post_thumbnail_id, true );
		}

		// And finally assign featured image to post
		set_post_thumbnail( $post_id, $attach_id );
		update_post_meta( $post_id, 'wplp_media_image', 'false');

		return 'success';
	}

	function wplp_small_screenshot($image_name, $data, $post_id) {
		$data = str_replace('_', '/', $data);
		$data = str_replace('-', '+', $data);
		$base64img = str_replace('data:image/jpeg;base64,', '', $data);

		$data   		  = base64_decode($data);
		$upload_dir       = WPLP_UPLOAD_DIR; // Set upload folder
		$image_data       = $data; // img data
		$unique_file_name = wp_unique_filename( $upload_dir, $image_name ); // Generate unique name
		$filename         = basename( $unique_file_name ); // Create image file name


		$tmp = WPLP_UPLOAD_DIR . $image_name . '.jpg';
		// Create the image  file on the server
		$filep = file_put_contents( $tmp, $image_data );

		$exists = file_exists($tmp);
		if ($exists == true) {
			$file = WPLP_UPLOAD_DIR . $filename . time() . '.jpg';
		}
		$move = rename($tmp, $file);

		// Check image file type
		$wp_filetype = wp_check_filetype( $file, null );

		// Set attachment data
		$attachment = array(
			'post_mime_type' => $wp_filetype['type'],
			'post_title'     => sanitize_file_name( $filename ),
			'post_content'   => '',
			'post_status'    => 'inherit'
		);

		// Create the attachment
		$attach_id = wp_insert_attachment( $attachment, $file, $post_id );

		// Include image.php
		require_once(ABSPATH . 'wp-admin/includes/image.php');

		// Define attachment metadata
		$attach_data = wp_generate_attachment_metadata( $attach_id, $file );

		// Assign metadata to attachment
		wp_update_attachment_metadata( $attach_id, $attach_data );
		$post_thumbnail_id = get_post_thumbnail_id( $post_id );

		$mk = wplp_filter_metadata( get_post_meta( $post_id ) );
		if (!empty($post_thumbnail_id) && $mk['wplp_media_image'] != 'true') {
			wp_delete_attachment( $post_thumbnail_id, true );
		}

		// And finally assign featured image to post
		set_post_thumbnail( $post_id, $attach_id );
		update_post_meta( $post_id, 'wplp_media_image', 'false');

		return 'success';
	}

	function wplp_favicon($image_url, $image_name, $post_id) {
		$stripped = strtok($image_url, "?");
		$ext = pathinfo($stripped,PATHINFO_EXTENSION);
		$image_name = $image_name.'.'.$ext;
		$upload_dir       = WPLP_UPLOAD_DIR; // Set upload folder
		$unique_file_name = wp_unique_filename( $upload_dir, $image_name ); // Generate unique name
		$filename         = basename( $unique_file_name ); // Create image file name


		// Save as a temporary file
		$down_url = $image_url;
		$tmp = download_url( $down_url );

		// Check for download errors
		if ( is_wp_error( $tmp ) )
		{
			@unlink( $file_array[ 'tmp_name' ] );
			update_post_meta( $post_id, 'wplp_favicon', '' );
			return $tmp;
		}

		$img_url = WPLP_UPLOAD_URL.$image_name;

		$file = WPLP_UPLOAD_DIR . $image_name;


		// Take care of image files without extension:
		$path = pathinfo( $tmp );
		if( ! isset( $path['extension'] ) ):
			$tmpnew = $tmp . $ext;
			if( ! rename( $tmp, $tmpnew ) ):
			update_post_meta( $post_id, 'wplp_favicon', '' );
				return '';
			else:
				$tmp = $tmpnew;
			endif;
		endif;
		if( $path['extension'] == 'tmp' ):
			$tmpnew = $path['dirname'].'/'.$path['filename'] . $ext;
			if( ! rename( $tmp, $tmpnew ) ):
			update_post_meta( $post_id, 'wplp_favicon', '' );
				return '';
			else:
				$tmp = $tmpnew;
			endif;
		endif;


		$exists = file_exists($file);
		if ($exists == true) {
			$file = WPLP_UPLOAD_DIR . $filename;
		}
		$move = rename($tmp, $file);

		// Check image file type
		$wp_filetype = wp_check_filetype( $file, null );

		// Set attachment data
		$attachment = array(
			'post_mime_type' => $wp_filetype['type'],
			'post_title'     => sanitize_file_name( $filename ),
			'post_content'   => '',
			'post_status'    => 'inherit'
		);

		$mk = wplp_filter_metadata( get_post_meta( $post_id ) );

		if (!empty($mk['wplp_favicon']) && $mk['wplp_media_fav'] != 'true') {
			wp_delete_attachment( $mk['wplp_favicon'], true );
		}
		// Create the attachment
		$attach_id = wp_insert_attachment( $attachment, $file, $post_id );

		// Include image.php
		require_once(ABSPATH . 'wp-admin/includes/image.php');

		// Define attachment metadata
		$attach_data = wp_generate_attachment_metadata( $attach_id, $file );

		// Assign metadata to attachment
		wp_update_attachment_metadata( $attach_id, $attach_data );

		update_post_meta( $post_id, 'wplp_favicon', $attach_id );
		update_post_meta( $post_id, 'wplp_media_fav', 'false');

		return 'success';
	}


	/* Shortcode - Links Display*/

	add_filter( 'the_content', 'wplp_remove_autop', 0 );
	function wplp_remove_autop( $content )
	{
		 global $post;
		 // Check for single page and image post type and remove
		 if ( $post->post_type == 'wplp_link' )
			  remove_filter('the_content', 'wpautop');

		 return $content;
	}


	function wplp_shortcode_sort() {
		if (isset($_REQUEST['data'])) {
			$data = $_REQUEST['data'];
		} else die(json_encode(array('message' => 'ERROR', 'code' => 1111)));

		$data = stripslashes($data);
		$atts = json_decode($data, true);
		$content = wplp_shortcode($atts);
		echo $content;
		wp_die();
	}
	add_action( 'wp_ajax_nopriv_wplp_shortcode_sort', 'wplp_shortcode_sort');
	add_action( 'wp_ajax_wplp_shortcode_sort', 'wplp_shortcode_sort');


	function wplp_shortcode($atts){

		if (get_option('wplp_grid') != false) {
			$dis = get_option('wplp_grid');
		} else { $dis = 'grid'; }
		if (get_option('wplp_width') != false) {
			$col = get_option('wplp_width');
		} else { $col = '3'; }

		if (get_option('wplpf_grid') != false) {
			$dis = get_option('wplpf_grid');
		} else { $dis = 'grid'; }
		if (get_option('wplpf_width') != false) {
			$col = get_option('wplpf_width');
		} else { $col = '3'; }

		$vars = shortcode_atts( array(
			'ids' => '',
			'type' => '',
			'display' => 'grid',
			'cols' => '3',
			'pager' => 'pagination',
			'load_more' => 'Load More',
			'num' => '',
			'limit' => '',
			'order' => 'DESC',
			'orderby' => 'ID',
			'sort' => '',
			'cat' => '',
			'category' => '',
			'tag' => '',
			'image' => 'ss',
			'img_size' => 'medium',
			'img_style' => '',
			'title' => 'display',
			'title_style' => '',
			'desc' => '',
			'description' => '',
			'description_link' => 'yes',
			'desc_style' => '',
			'slides' => '3',
			'slide_scroll' => '1',
			'autoplay' => 'true',
			'infinite' => 'true',
			'ajax' => 'false',
			'paged' => '',
			), $atts );

		$default_num_posts = get_option( 'posts_per_page' );
		$display = $vars['display'];
		$type = $vars['type'];
		if ($type != '' && $display == 'grid') {
			$display = $type;
		}
		$cols = $vars['cols'];
		$pager = $vars['pager'];
		$load_more = $vars['load_more'];
		$paged_num = $vars['num'];
		$limit = $vars['limit'];
		if (is_numeric($pager)) {
			$limit = $pager;
			$pager = 'pagination';
		}
		if ($limit != '' && $paged_num == '') {
			$paged_num = $limit;
		}
		if ($paged_num == '' && $display == 'grid') {
			$paged_num = $default_num_posts*$cols;
		}
		if ($paged_num == 'all' || $display == 'carousel') {
			$paged_num = -1;
		}
		$order = $vars['order'];
		$meta = '';
		$orderby = $vars['orderby'];
		$sort = $vars['sort'];
		if ($sort == 'random' && $orderby == 'ID') {
			$oderby = 'rand';
		}
		if ($orderby == 'title') {
			$orderby = 'meta_value';
			$meta = 'wpls_display';
		}
		$cat = $vars['cat'];
		$category = $vars['category'];
		if ($category != '' && $cat == '') {
			$cat = get_cat_ID( $category );
		}
		$tag = $vars['tag'];
		$tags = explode(',', $tag);
		$new_tags = array();
		foreach ($tags as $tag) {
			$tag = trim($tag);
			$tag = str_replace(' ','-',$tag);
			$new_tags[] = $tag;
		}
		$tags = implode(',',$new_tags);
		$image = $vars['image'];
		$img_size = $vars['img_size'];
		$img_style = $vars['img_style'];
		$title = $vars['title'];
		$title_style = $vars['title_style'];
		$desc = $vars['desc'];
		$description = $vars['description'];
		if ($description == 'yes' && $desc == '') {
			$desc = 'content';
		}
		$description_link = $vars['description_link'];
		$desc_style = $vars['desc_style'];
		$slides = $vars['slides'];
		$slide_scroll = $vars['slide_scroll'];
		$autoplay = $vars['autoplay'];
		$infinite = $vars['infinite'];
		$ids = $vars['ids'];
		$ajax = $vars['ajax'];
		$paged = $vars['paged'];

		wp_enqueue_style('wplp-display-style');
		wp_enqueue_script('wplp-display-js');

		if ($display == 'carousel') {
			wp_enqueue_script('wplp-slick-js');
			wp_enqueue_style('wplp-slick-style');
		}

		if ($pager == 'infinite' || $pager == 'view_more') {
			wp_enqueue_script('wplp-jscroll-js');
		}
		if (!empty($s)) {
			$meta_query = array(
				'relation' => 'OR',
				array(
					'key'     => 'wplp_display',
					'value'   => $s,
					'compare' => 'REGEXP',
				),
				array(
					'key'     => 'wplp_meta_desc',
					'value'   => $s,
					'compare' => 'REGEXP',
				),
				);
		} else $meta_query = array();

		global $wpdb;
		$grid = '';
		$list = '';
		$compactlist = '';
		$gallery = '';
		$carousel = '';
		$i = 0;
		if (is_front_page() && $paged == '') {
			$paged = ( get_query_var( 'page' ) ) ? absint( get_query_var( 'page' ) ) : 1;
		} else if ($paged == '') $paged = ( get_query_var( 'paged' ) ) ? absint( get_query_var( 'paged' ) ) : 1;
		if (!empty($cat)) {
      if (strpos($cat,',') !== false) {
          $cat = explode(',',$cat);
      }
			$catq = array( 'taxonomy' => 'wplp_link_category', 'field' => 'term_id', 'terms' => $cat, );
		}
		if (!empty($tag)) {
			$tagq = array( 'taxonomy' => 'wplp_tag', 'field' => 'term_id', 'terms' => $tag, );
		}
		if (!empty($cat) && !empty($tag)) {
			$taxq = array( $catq, $tagq, );
		}
		if (!empty($cat) && empty($tag)) {
			$taxq = array( $catq );
		}
		if (empty($cat) && !empty($tag)) {
			$taxq = array( $tagq );
		}
		if (empty($cat) && empty($tag)) {
			$taxq = array();
		}
		$query_args = array('post_type' => 'wplp_link', 'posts_per_page' => $paged_num, 'order' => $order, 'orderby' => $orderby, 'tax_query' => $taxq, 'meta_key' => 'wplp_display', 'metakey' => $meta, 'post_status' => 'publish');

		if ($paged_num != -1) {
			$query_args['paged'] = $paged;
		}
		if ($ids != '') {
			$idarr = explode(',', $ids);
			$query_args['post__in'] = $idarr;
		}
		remove_all_filters('posts_orderby');
		$custom_query = new WP_Query( $query_args );

		if (!empty($s)) {
			$query_args = array('post_type' => 'wplp_link', 'posts_per_page' => -1, 'order' => $order, 'orderby' => $orderby, 'tax_query' => $taxq, 'meta_key' => 'wplp_display', 'metakey' => $meta, 's' => $s, 'post_status' => 'publish');
			$custom_query1 = new WP_Query( $query_args );
			$query_args2 = array('post_type' => 'wplp_link', 'posts_per_page' => -1, 'order' => $order, 'orderby' => $orderby, 'tax_query' => $taxq, 'meta_key' => 'wplp_display', 'meta_query' => $meta_query, 'post_status' => 'publish' );
			$custom_query2 = new WP_Query( $query_args2 );
			$custom_query1->posts = array_values(array_unique(array_merge($custom_query1->posts, $custom_query2->posts ), SORT_REGULAR));
			$post_ids = wp_list_pluck($custom_query1->posts, 'ID');
			$custom_query = new WP_Query( array( 'post__in' => $post_ids, 'post_type' => 'wplp_link', 'order' => $order, 'order_by' => $orderby, 'posts_per_page' => $paged_num, 'post_status' => 'publish', 'paged' => $paged ) );
		}

		while($custom_query->have_posts()) : $custom_query->the_post();
			$post_id = get_the_ID();
			$mk = wplp_filter_metadata( get_post_meta( $post_id ) );
			if (isset($mk['wplp_favicon'])) {$mfavicon = $mk['wplp_favicon'];} else {$mfavicon = '';}
			if (isset($mk['wplp_media_fav'])) {$mfav_media = $mk['wplp_media_fav'];} else {$mfav_media = '';}
			if (isset($mk['wplp_meta_title'])) {$mmtitle = $mk['wplp_meta_title'];} else {$mmtitle = '';}
			if (isset($mk['wplp_meta_desc'])) {$mmdesc = $mk['wplp_meta_desc'];} else {$mmdesc = '';}
			if (isset($mk['wplp_display'])) {$mdisp = $mk['wplp_display'];} else {$mdisp = '';}

      $url = the_title("","",false);

      // Image
			$img = '';
			if ($image == 'ss') {
				$thumb = get_post_thumbnail_id($post_id);
				$img = wp_get_attachment_image($thumb, $img_size, false, array('style' => $img_style));
			} elseif ($image == 'fav' && isset($mk['wplp_favicon'])) {
				$img = wp_get_attachment_image($mfavicon, 'full', false, array('style' => $img_style));
				if (empty($img)) {
					$default_id = esc_attr( get_option('wplp_default_favicon'));
					if ($default_id == 'false') {
						$img = '<img src="'.plugins_url( '/images/default-favicon.ico', __FILE__ ).'" class="attachment-full size-full" alt="" style="'.$img_style.'" >';
					} else {
						$img = wp_get_attachment_image( $default_id, 'full', false, array('style' => $img_style));
					}
				}
			} elseif ($image == 'fav' && !isset($mk['wplp_favicon'])) {
				if (empty($img)) {
					$default_id = esc_attr( get_option('wplp_default_favicon'));
					if ($default_id == 'false') {
						$img = '<img src="'.plugins_url( '/images/default-favicon.ico', __FILE__ ).'" class="attachment-full size-full" alt="" style="'.$img_style.'" >';
					} else {
						$img = wp_get_attachment_image( $default_id, 'full', false, array('style' => $img_style));
					}
				}
			}

			// Title
			$title_display = '';
			if ($title == 'display') {
				$title_display = $mdisp;
			} elseif ($title == 'meta') {
				$title_display = $mmtitle;
			}

			// Description
			$description = '';
			if ($desc == 'content') {
				$description = apply_filters('the_content',get_the_content());
			} elseif ($desc == 'meta') {
				$description = $mmdesc;
			}
			if (!empty($description) && $display == 'compactlist') {
				$description = '<span class="wplp_desc" style="'.$desc_style.'">'.$description.'</span>';
			} else {
				$description = '<p class="wplp_desc" style="'.$desc_style.'">'.$description.'</p>';
			}

			if ($description_link == 'yes') {
				$description = $description.'</a>';
			} else {
				$description = '</a>'.$description;
			}



			if ($display == 'grid') {
				$gallery .= '<figure id="gallery-item-'.$i.'" class="gallery-item wplp-item">
				<div class="gallery-icon landscape">
				<a class="wplp_link" href="'.$url.'" target="_blank">
				'.$img.'
				<p class="wplp_display" style="'.$title_style.'" >'.$title_display.'</p>
				'.$description.'
				</div>
				</figure>';
			} elseif ($display == 'list') {
				$list .= '<div id="wplp_list-item-'.$i.'" class="list-item wplp-item">
				<a class="wplp_link" href="'.$url.'" target="_blank">
				<div class="list-img">'.$img.'</div>
				<p class="wplp_display" style="'.$title_style.'" >'.$title_display.'</p>
				'.$description.'
				</div>
				<hr>';
			} elseif ($display == 'compactlist') {
				$compactlist .= '<div id="wplp_compact_list-item-'.$i.'" class="list-item wplp-item">
				<a class="wplp_link" href="'.$url.'" target="_blank">
				<span class="list-img">'.$img.'</span>
				<span class="wplp_display" style="'.$title_style.'" >'.$title_display.'</span>
				'.$description.'
				</div>';
			} elseif ($display == 'carousel') {
				$filter = "false";
				$sform = "false";
				$carousel .= '<div id="carousel-item-'.$i.'" class="carousel-item slick-slide wplp-item">
				<div class="carousel-icon landscape">
				<a class="wplp_link" href="'.$url.'" target="_blank">
				'.$img.'
				<p class="wplp_display" style="'.$title_style.'" >'.$title_display.'</p>
				'.$description.'
				</a>
				</div>
				</div>';
		}
		$i++;

		endwhile;

		if ($pager == 'pagination') {
			$current = max( 1, $paged );
			$big = 999999999;
			$pagination = '<div id="pagination" class="pagination">'.
					paginate_links( array(
						'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
						'format' => '?paged=%#%',
						'current' => $current,
						'total' => $custom_query->max_num_pages
					) )
			.'</div>';
			$class = "pagination";
		} elseif ($pager == 'view_more') {
			$current = max( 1, $paged );
			$big = 999999999;
			$pagination = '<div id="wplp_view_more" class="pagination'.(($ajax == 'true') ? 'ajax':'').'">'.
					paginate_links( array(
						'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
						'format' => '?paged=%#%',
						'current' => $current,
						'total' => $custom_query->max_num_pages,
						'next_text' => __($load_more),
					) )
			.'</div>';
			$class = "wplp-view-more";
		} elseif ($pager == 'infinite') {
			$filter = "false";
			$sform = "false";
			$current = max( 1, $paged );
			$big = 999999999;
			$pagination = '<div class="pagination" style="display:none;">'.
					paginate_links( array(
						'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
						'format' => '?paged=%#%',
						'current' => $current,
						'total' => $custom_query->max_num_pages
					) )
			.'</div>';
			$class = "wplp-infinite";
		} elseif ($pager == 'none') {
			$pagination = '';
			$class = "";
		}

		if ($display == 'grid') {
			$output = '<div style="clear:both;"></div><div id="gallery-wplp" class="galleryid-wplp gallery-columns-'.$cols.' '.$class.' wplp-display">'.$gallery.$pagination.'</div><div style="clear:both;"></div>';
		} elseif ($display == 'list') {
			$output = '<div style="clear:both;"></div><div id="list-wplp" class="listid-wplp '.$class.' wplp-display">'.$list.$pagination.'</div><div style="clear:both;"></div>';
		} elseif ($display == 'compactlist') {
			$output = '<div style="clear:both;"></div><div id="compactlist-wplp" class="compactlistid-wplp '.$class.' wplp-display">'.$compactlist.$pagination.'</div><div style="clear:both;"></div>';
		} elseif ($display == 'carousel') {
			if ($slide_scroll == 'all') {$slide_scroll = $slides;}
			$output = '<div style="clear:both;"></div><div id="carousel-wplp" class="carousel-wplp carousel-columns-'.$slides.' wplp-display" data-slick=\'{"slidesToShow": '.$slides.', "slidesToScroll": '.$slide_scroll.', "infinite": '.$infinite.', "autoplay": '.$autoplay.' }\' >'.$carousel.'</div><div style="clear:both;"></div>';
		}
		wp_reset_query();

		if ($ajax == "true") {
			$output = $output."<script>jQuery('.page-numbers').click(function(e) {
			e.preventDefault();

			var sortBy = '".$s."';
			var links_this = jQuery(this);
			var atts = jQuery(this).parents('.wp-links-page-display').children('#archive-browser').attr('data-atts');
			var obj = jQuery.parseJSON(atts);
			obj.filter = 'false';
			obj.sform = 'false';
			obj.ajax = 'true';
			obj.s = '".$s."';

			var page = 1;
			if (jQuery(this).hasClass('next')) {
				page = parseInt(jQuery(this).siblings('.current').text()) + 1;
			} else {
				page = jQuery(this).text();
			}
			var pager = obj.pager;
			obj.paged = page;

			jQuery.post(ajax_object.ajax_url,{
					'data': JSON.stringify(obj),
					'action': 'wplp_shortcode_sort',
				}
			)
			.done(function(response) {
				if (pager == 'view_more') {
					jQuery(links_this).parents('.wp-links-page-display').children('.wplp-display').append(response);
					jQuery(links_this).parents('.wp-links-page-sort').attr('data-atts', JSON.stringify(obj) );
					jQuery(links_this).parents('.paginationajax').remove();
				} else {
					jQuery(links_this).parents('.wp-links-page-display').children('.wplp-display').html(response);
					jQuery(links_this).parents('.wp-links-page-sort').attr('data-atts', JSON.stringify(obj) );
				}
			})


		});

		</script>";
		}
			return $output;
	}
	add_shortcode('wp_links_page', 'wplp_shortcode');


	add_shortcode('wp_links_page_free', 'wplp_shortcode');
}
?>
